/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.Event;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TabPane;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.eclipse.fx.ui.controls.dnd.EFXDragEvent;
import org.eclipse.fx.ui.controls.markers.PositionMarker;
import org.eclipse.fx.ui.controls.markers.TabOutlineMarker;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.controls.tabpane.GenericTabPane;
import org.eclipse.fx.ui.controls.tabpane.skin.DnDTabPaneSkin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DndTabPaneFactory {
    private static MarkerFeedback CURRENT_FEEDBACK;

    private DndTabPaneFactory() {
    }

    public static <D extends Node> Pane setup(FeedbackType feedbackType, D dragSetup, Consumer<GenericTab> detachHandler) {
        StackPane pane = new StackPane();
        DndTabPaneFactory.setup(feedbackType, (Pane)pane, (DragSetup)dragSetup, detachHandler);
        pane.getChildren().add(dragSetup);
        return pane;
    }

    public static TabPane createDndTabPane(final Consumer<DragSetup> setup) {
        return new TabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin skin = new DnDTabPaneSkin(this);
                setup.accept(skin);
                return skin;
            }
        };
    }

    public static Pane createDefaultDnDPane(final FeedbackType feedbackType, Consumer<TabPane> setup) {
        final StackPane pane = new StackPane();
        TabPane tabPane = new TabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin skin = new DnDTabPaneSkin(this);
                DndTabPaneFactory.setup(feedbackType, (Pane)pane, skin, null);
                return skin;
            }
        };
        setup.accept(tabPane);
        pane.getChildren().add((Object)tabPane);
        return pane;
    }

    public static boolean hasDnDContent(Event e) {
        if (e instanceof DragEvent) {
            return ((DragEvent)e).getDragboard().hasContent(DnDTabPaneSkin.TAB_MOVE);
        }
        if (e instanceof EFXDragEvent) {
            return ((EFXDragEvent)e).getDraggedContent() != null;
        }
        return false;
    }

    public static String getDnDContent(Event e) {
        if (e instanceof DragEvent) {
            return (String)((DragEvent)e).getDragboard().getContent(DnDTabPaneSkin.TAB_MOVE);
        }
        if (e instanceof EFXDragEvent) {
            return (String)((EFXDragEvent)e).getDraggedContent();
        }
        return null;
    }

    static void setup(FeedbackType type, Pane layoutNode, DragSetup setup, Consumer<GenericTab> detachHandler) {
        setup.setStartFunction(t -> Boolean.TRUE);
        setup.setFeedbackConsumer(d -> DndTabPaneFactory.handleFeedback(type, layoutNode, d));
        setup.setDropConsumer(d -> DndTabPaneFactory.handleDropped(d, detachHandler));
        setup.setDragFinishedConsumer(DndTabPaneFactory::handleFinished);
    }

    private static void handleDropped(DroppedData data, Consumer<GenericTab> detachHandler) {
        if (data.dropType == DropType.DETACH) {
            if (detachHandler != null) {
                detachHandler.accept(data.draggedTab);
            }
        } else {
            GenericTabPane targetPane = data.targetTab.getOwner();
            data.draggedTab.getOwner().remove(data.draggedTab);
            int idx = targetPane.indexOf(data.targetTab);
            if (data.dropType == DropType.AFTER) {
                if (idx + 1 <= targetPane.getTabNumber()) {
                    targetPane.add(idx + 1, data.draggedTab);
                } else {
                    targetPane.add(data.draggedTab);
                }
            } else {
                targetPane.add(idx, data.draggedTab);
            }
            data.draggedTab.getOwner().select(data.draggedTab);
        }
    }

    private static void handleFeedback(FeedbackType type, Pane layoutNode, FeedbackData data) {
        if (data.dropType == DropType.NONE) {
            DndTabPaneFactory.cleanup();
            return;
        }
        MarkerFeedback f = CURRENT_FEEDBACK;
        if (f == null || !f.data.equals(data)) {
            DndTabPaneFactory.cleanup();
            CURRENT_FEEDBACK = type == FeedbackType.MARKER ? DndTabPaneFactory.handleMarker(layoutNode, data) : DndTabPaneFactory.handleOutline(layoutNode, data);
        }
    }

    private static void handleFinished(GenericTab tab) {
        DndTabPaneFactory.cleanup();
    }

    static void cleanup() {
        if (CURRENT_FEEDBACK != null) {
            CURRENT_FEEDBACK.hide();
            CURRENT_FEEDBACK = null;
        }
    }

    private static MarkerFeedback handleMarker(Pane layoutNode, FeedbackData data) {
        PositionMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof PositionMarker)) continue;
            marker = (PositionMarker)n;
        }
        if (marker == null) {
            marker = new PositionMarker();
            marker.setManaged(false);
            layoutNode.getChildren().add((Object)marker);
        } else {
            marker.setVisible(true);
        }
        double w = marker.getBoundsInLocal().getWidth();
        double h = marker.getBoundsInLocal().getHeight();
        double ratio = data.bounds.getHeight() / h;
        marker.setScaleX(ratio += 0.1);
        marker.setScaleY(ratio);
        double wDiff = w / 2.0;
        double hDiff = (h - h * ratio) / 2.0;
        if (data.dropType == DropType.AFTER) {
            marker.relocate(data.bounds.getMinX() + data.bounds.getWidth() - wDiff, data.bounds.getMinY() - hDiff);
        } else {
            marker.relocate(data.bounds.getMinX() - wDiff, data.bounds.getMinY() - hDiff);
        }
        final PositionMarker fmarker = marker;
        return new MarkerFeedback(data){

            @Override
            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }

    private static MarkerFeedback handleOutline(Pane layoutNode, FeedbackData data) {
        TabOutlineMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof TabOutlineMarker)) continue;
            marker = (TabOutlineMarker)n;
        }
        if (marker == null) {
            marker = new TabOutlineMarker(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight()), data.dropType == DropType.BEFORE);
            marker.setManaged(false);
            marker.setMouseTransparent(true);
            layoutNode.getChildren().add((Object)marker);
        } else {
            marker.updateBounds(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight()), data.dropType == DropType.BEFORE);
            marker.setVisible(true);
        }
        final TabOutlineMarker fmarker = marker;
        return new MarkerFeedback(data){

            @Override
            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }

    public static interface DragSetup {
        public void setStartFunction(@Nullable Function<@NonNull GenericTab, @NonNull Boolean> var1);

        public void setDragFinishedConsumer(@Nullable Consumer<@NonNull GenericTab> var1);

        public void setFeedbackConsumer(@Nullable Consumer<@NonNull FeedbackData> var1);

        public void setDropConsumer(@Nullable Consumer<@NonNull DroppedData> var1);

        public void setClipboardDataFunction(@Nullable Function<@NonNull GenericTab, @NonNull String> var1);
    }

    public static enum DropType {
        NONE,
        BEFORE,
        AFTER,
        DETACH;

    }

    public static class DroppedData {
        public final @NonNull GenericTab draggedTab;
        public final @NonNull GenericTab targetTab;
        public final @NonNull DropType dropType;
        public final double x;
        public final double y;

        public DroppedData(double x, double y, @NonNull GenericTab draggedTab, @NonNull GenericTab targetTab, @NonNull DropType dropType) {
            this.x = x;
            this.y = y;
            this.draggedTab = draggedTab;
            this.targetTab = targetTab;
            this.dropType = dropType;
        }
    }

    public static class FeedbackData {
        public final @NonNull GenericTab draggedTab;
        public final GenericTab targetTab;
        public final Bounds bounds;
        public final @NonNull DropType dropType;

        public FeedbackData(@NonNull GenericTab draggedTab, GenericTab targetTab, Bounds bounds, @NonNull DropType dropType) {
            this.draggedTab = draggedTab;
            this.targetTab = targetTab;
            this.bounds = bounds;
            this.dropType = dropType;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
            result = 31 * result + this.draggedTab.hashCode();
            result = 31 * result + this.dropType.hashCode();
            result = 31 * result + (this.targetTab == null ? 0 : this.targetTab.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeedbackData other = (FeedbackData)obj;
            if (this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds)) {
                return false;
            }
            if (!this.draggedTab.equals(other.draggedTab)) {
                return false;
            }
            if (this.dropType != other.dropType) {
                return false;
            }
            return !(this.targetTab == null ? other.targetTab != null : !this.targetTab.equals(other.targetTab));
        }
    }

    public static enum FeedbackType {
        MARKER,
        OUTLINE;

    }

    private static abstract class MarkerFeedback {
        public final FeedbackData data;

        public MarkerFeedback(FeedbackData data) {
            this.data = data;
        }

        public abstract void hide();
    }
}

