/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.tk.Toolkit;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class TextLayouter {
    private final Runnable layoutRunnable;
    private final Pane layoutPane;

    public TextLayouter(boolean useraster, final Runnable layoutRunnable) {
        this.layoutPane = useraster ? new RasterLayoutPane(layoutRunnable) : new TextFlow(){

            protected void layoutChildren() {
                super.layoutChildren();
                layoutRunnable.run();
            }
        };
        this.layoutPane.setUserData((Object)this);
        this.layoutRunnable = layoutRunnable;
    }

    public void setText(String text) {
        if (this.layoutPane instanceof RasterLayoutPane) {
            ((RasterLayoutPane)this.layoutPane).setText(text);
        }
    }

    public Pane getLayoutPane() {
        return this.layoutPane;
    }

    class RasterLayoutPane
    extends Pane {
        private Runnable layoutRunnable;
        private String text;
        private GlyphList glyphList;

        public RasterLayoutPane(Runnable layoutRunnable) {
            this.layoutRunnable = layoutRunnable;
        }

        public void setText(String text) {
            this.text = text;
            this.glyphList = null;
        }

        protected void layoutChildren() {
            super.layoutChildren();
            try {
                if (!this.getChildren().isEmpty()) {
                    TextFlow f = (TextFlow)this.getChildren().get(0);
                    if (this.glyphList == null) {
                        TextLayoutFactory factory = Toolkit.getToolkit().getTextLayoutFactory();
                        TextLayout layout = factory.createLayout();
                        layout.setContent(this.text, ((Text)f.getChildren().get(0)).getFont().impl_getNativeFont());
                        this.glyphList = layout.getLines()[0].getRuns()[0];
                    }
                    int start = (Integer)f.getUserData();
                    for (Node n : this.getChildren()) {
                        double offset = this.glyphList.getPosX((Integer)n.getUserData() - start);
                        TextFlow t = (TextFlow)n;
                        t.relocate(offset, 0.0);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.layoutRunnable.run();
        }
    }
}

