/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXClassmodel;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXCtrlClass;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public class FXClassmodel
implements IFXClassmodel {
    private Map<String, FXClass> fxClassCache = new HashMap<String, FXClass>();
    private Map<String, FXCtrlClass> fxCtrlClassCache = new HashMap<String, FXCtrlClass>();

    @Override
    public IFXClass findClass(IJavaProject javaProject, IType type) {
        IFXClass rv = this.fxClassCache.get(type.getFullyQualifiedName());
        if (rv == null) {
            FXClass c = new FXClass(javaProject, type);
            this.fxClassCache.put(c.getFQN(), c);
            rv = c;
        }
        return rv;
    }

    @Override
    public IFXCtrlClass findCtrlClass(IJavaProject javaProject, IType type) {
        IFXCtrlClass rv = this.fxCtrlClassCache.get(type.getFullyQualifiedName());
        if (rv == null) {
            FXCtrlClass c = new FXCtrlClass(javaProject, type);
            this.fxCtrlClassCache.put(c.getFQN(), c);
            rv = c;
        }
        return rv;
    }

    @Override
    public void clearCache(IType type) {
        String fqn = type.getFullyQualifiedName();
        this.fxClassCache.remove(fqn);
        this.fxCtrlClassCache.remove(fqn);
    }
}

