/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.converter;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.fxgraph.converter.CastHelper;
import org.eclipse.fx.ide.fxgraph.converter.ValuePropertyFormatter;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FactoryValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FXGraphConverter {
    public CharSequence generate(Model model) {
        int _length;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        PackageDeclaration _package = null;
        if (model != null) {
            _package = model.getPackage();
        }
        String _name = null;
        if (_package != null) {
            _name = _package.getName();
        }
        boolean bl = _greaterThan = (_length = _name.length()) > 0;
        if (_greaterThan) {
            _builder.append((Object)"package ");
            PackageDeclaration _package_1 = model.getPackage();
            String _name_1 = _package_1.getName();
            _builder.append((Object)_name_1, "");
            _builder.newLineIfNotEmpty();
        }
        EList<Import> _imports = model.getImports();
        CharSequence _generateImports = this.generateImports(_imports);
        _builder.append((Object)_generateImports, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ComponentDefinition _componentDef = model.getComponentDef();
        CharSequence _generateComponentDefinition = this.generateComponentDefinition(_componentDef);
        _builder.append((Object)_generateComponentDefinition, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateComponentDefinition(ComponentDefinition cd) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isDynamicRoot = cd.isDynamicRoot();
        if (_isDynamicRoot) {
            _builder.append((Object)"dynamic ");
        }
        _builder.append((Object)"component ");
        String _name = cd.getName();
        _builder.append((Object)_name, "");
        JvmTypeReference _controller = cd.getController();
        CharSequence _generateController = this.generateController(_controller);
        _builder.append((Object)_generateController, "");
        EList<String> _previewCssFiles = cd.getPreviewCssFiles();
        CharSequence _generateStyle = this.generateStyle(_previewCssFiles);
        _builder.append((Object)_generateStyle, "");
        String _previewResourceBundle = cd.getPreviewResourceBundle();
        CharSequence _generateResourceBundle = this.generateResourceBundle(_previewResourceBundle);
        _builder.append((Object)_generateResourceBundle, "");
        EList<String> _previewClasspathEntries = cd.getPreviewClasspathEntries();
        CharSequence _generateExtraClassPath = this.generateExtraClassPath(_previewClasspathEntries);
        _builder.append((Object)_generateExtraClassPath, "");
        ComponentDefinition _sceneDefinition = cd.getSceneDefinition();
        CharSequence _generateSceneSetup = this.generateSceneSetup(_sceneDefinition);
        _builder.append((Object)_generateSceneSetup, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        EList<Script> _scripts = cd.getScripts();
        for (Script s : _scripts) {
            _builder.append((Object)"\t");
            CharSequence _generateScript = this.generateScript(s);
            _builder.append((Object)_generateScript, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<Define> _defines = cd.getDefines();
        for (Define d : _defines) {
            _builder.append((Object)"\t");
            if (comma.booleanValue()) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateDefine = this.generateDefine(d);
            _builder.append((Object)_generateDefine, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            comma = true;
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        Element _rootNode = cd.getRootNode();
        CharSequence _generateElement = this.generateElement(_rootNode);
        _builder.append((Object)_generateElement, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateDefine(Define define) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"define ");
        Element _element = define.getElement();
        CharSequence _generateElement = this.generateElement(_element);
        _builder.append((Object)_generateElement, "");
        return _builder;
    }

    public CharSequence generateController(JvmTypeReference controller) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)controller, null);
        if (_notEquals) {
            _builder.append((Object)" controlledby ");
            JvmType _type = controller.getType();
            String _simpleName = _type.getSimpleName();
            _builder.append((Object)_simpleName, "");
        }
        return _builder;
    }

    public CharSequence generateStyle(EList<String> previewCssFiles) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = previewCssFiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)" styledwith [\"");
            for (String css : previewCssFiles) {
                _builder.append((Object)css, "");
            }
            _builder.append((Object)"\"]");
        }
        return _builder;
    }

    public CharSequence generateResourceBundle(String previewResourceBundle) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)previewResourceBundle, null);
        if (_notEquals) {
            _builder.append((Object)" resourcefile \"");
            _builder.append((Object)previewResourceBundle, "");
            _builder.append((Object)"\"");
        }
        return _builder;
    }

    public CharSequence generateExtraClassPath(EList<String> previewClasspathEntries) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = previewClasspathEntries.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)" extraClasspath [\"");
            for (String cp : previewClasspathEntries) {
                _builder.append((Object)cp, "");
            }
            _builder.append((Object)"\"]");
        }
        return _builder;
    }

    public CharSequence generateSceneSetup(ComponentDefinition sceneDefinition) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)sceneDefinition, null);
        if (_notEquals) {
            _builder.append((Object)" sceneSetup \"");
            CharSequence _generateComponentDefinition = this.generateComponentDefinition(sceneDefinition);
            _builder.append((Object)_generateComponentDefinition, "");
            _builder.append((Object)"\"");
        }
        return _builder;
    }

    public CharSequence generateImports(EList<Import> imports) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = imports.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.newLine();
        }
        for (Import imp : imports) {
            _builder.append((Object)"import ");
            String _importedNamespace = imp.getImportedNamespace();
            _builder.append((Object)_importedNamespace, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateScript(Script s) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"script ");
        String _language = s.getLanguage();
        _builder.append((Object)_language, "");
        _builder.append((Object)" #{");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _source = s.getSource();
        boolean bl = _notEquals = !Objects.equal((Object)_source, null);
        if (_notEquals) {
            String _source_1 = s.getSource();
            _builder.append((Object)_source_1, "\t");
        } else {
            String _sourcecode = s.getSourcecode();
            _builder.append((Object)_sourcecode, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}#\t");
        return _builder;
    }

    public CharSequence generateElement(Element element) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _factory = element.getFactory();
        boolean bl = _notEquals = !Objects.equal((Object)_factory, null);
        if (_notEquals) {
            JvmTypeReference _type = element.getType();
            String _simpleName = _type.getSimpleName();
            _builder.append((Object)_simpleName, "");
            _builder.append((Object)" createdby ");
            String _factory_1 = element.getFactory();
            _builder.append((Object)_factory_1, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            Boolean comma = false;
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values = element.getValues();
            for (FactoryValueElement e : _values) {
                if (comma.booleanValue()) {
                    _builder.append((Object)",");
                }
                if (e instanceof Element) {
                    CharSequence _generateElement = this.generateElement((Element)e);
                    _builder.append((Object)_generateElement, "");
                } else {
                    boolean cfr_ignored_0 = e instanceof SimpleValueProperty;
                    ValuePropertyFormatter _valuePropertyFormatter = new ValuePropertyFormatter(e);
                    String _formattedValue = _valuePropertyFormatter.getFormattedValue();
                    _builder.append((Object)_formattedValue, "");
                }
                _builder.newLineIfNotEmpty();
                comma = true;
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
        } else {
            boolean _elementHasSubEntries;
            String _name;
            boolean _notEquals_2;
            boolean _notEquals_1;
            _builder.newLineIfNotEmpty();
            JvmTypeReference _type_1 = element.getType();
            String _simpleName_1 = _type_1.getSimpleName();
            _builder.append((Object)_simpleName_1, "");
            SimpleValueProperty _value = element.getValue();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_value, null);
            if (_notEquals_1) {
                _builder.append((Object)" ( ");
                SimpleValueProperty _value_1 = element.getValue();
                String _stringValue = _value_1.getStringValue();
                _builder.append((Object)_stringValue, "");
                _builder.append((Object)" )");
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_name = element.getName()), null);
            if (_notEquals_2) {
                _builder.append((Object)" id ");
                String _name_1 = element.getName();
                _builder.append((Object)_name_1, "");
            }
            if (_elementHasSubEntries = this.elementHasSubEntries(element)) {
                boolean _greaterThan;
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                Boolean comma_1 = false;
                _builder.newLineIfNotEmpty();
                EList<Property> _properties = element.getProperties();
                for (Property p : _properties) {
                    ValueProperty _value_2;
                    if (comma_1.booleanValue()) {
                        _builder.append((Object)",");
                    }
                    if ((_value_2 = p.getValue()) instanceof Element) {
                        CharSequence _generatePropertyElement = this.generatePropertyElement(p);
                        _builder.append((Object)_generatePropertyElement, "");
                    } else {
                        ValueProperty _value_3 = p.getValue();
                        if (_value_3 instanceof ListValueProperty) {
                            CharSequence _generateListValueProperty = this.generateListValueProperty(p);
                            _builder.append((Object)_generateListValueProperty, "");
                        } else {
                            ValueProperty _value_4 = p.getValue();
                            if (_value_4 instanceof MapValueProperty) {
                                CharSequence _generateMapValueProperty = this.generateMapValueProperty(p);
                                _builder.append((Object)_generateMapValueProperty, "");
                            } else {
                                ValuePropertyFormatter _valuePropertyFormatter_1 = new ValuePropertyFormatter(p);
                                String _formattedValue_1 = _valuePropertyFormatter_1.getFormattedValue();
                                _builder.append((Object)_formattedValue_1, "");
                            }
                        }
                    }
                    _builder.newLineIfNotEmpty();
                    comma_1 = true;
                    _builder.newLineIfNotEmpty();
                }
                EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
                for (StaticValueProperty p_1 : _staticProperties) {
                    if (comma_1.booleanValue()) {
                        _builder.append((Object)",");
                    }
                    ValuePropertyFormatter _valuePropertyFormatter_2 = new ValuePropertyFormatter(p_1);
                    String _formattedValue_2 = _valuePropertyFormatter_2.getFormattedValue();
                    _builder.append((Object)_formattedValue_2, "");
                    _builder.newLineIfNotEmpty();
                    comma_1 = true;
                    _builder.newLineIfNotEmpty();
                }
                EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
                for (StaticCallValueProperty p_2 : _staticCallProperties) {
                    if (comma_1.booleanValue()) {
                        _builder.append((Object)",");
                    }
                    ValuePropertyFormatter _valuePropertyFormatter_3 = new ValuePropertyFormatter(p_2);
                    String _formattedValue_3 = _valuePropertyFormatter_3.getFormattedValue();
                    _builder.append((Object)_formattedValue_3, "");
                    _builder.newLineIfNotEmpty();
                    comma_1 = true;
                    _builder.newLineIfNotEmpty();
                }
                EList<Element> _defaultChildren = element.getDefaultChildren();
                int _size = _defaultChildren.size();
                boolean bl4 = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _builder.append((Object)"\t");
                    if (comma_1.booleanValue()) {
                        _builder.append((Object)",");
                    }
                    _builder.append((Object)"children : [");
                    _builder.newLineIfNotEmpty();
                    Boolean internalComma = false;
                    _builder.newLineIfNotEmpty();
                    EList<Element> _defaultChildren_1 = element.getDefaultChildren();
                    for (Element e_1 : _defaultChildren_1) {
                        if (internalComma.booleanValue()) {
                            _builder.append((Object)",");
                        }
                        CharSequence _generateElement_1 = this.generateElement(e_1);
                        _builder.append((Object)_generateElement_1, "");
                        _builder.newLineIfNotEmpty();
                        internalComma = true;
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"]");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
            }
        }
        return _builder;
    }

    public boolean elementHasSubEntries(Element element) {
        EList<Element> _defaultChildren;
        int _size_3;
        boolean _greaterThan_3;
        EList<StaticCallValueProperty> _staticCallProperties;
        int _size_2;
        boolean _greaterThan_2;
        EList<StaticValueProperty> _staticProperties;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        EList<Property> _properties = element.getProperties();
        int _size = _properties.size();
        boolean bl = _greaterThan = _size > 0;
        _or_2 = _greaterThan ? true : (_greaterThan_1 = (_size_1 = (_staticProperties = element.getStaticProperties()).size()) > 0);
        _or_1 = _or_2 ? true : (_greaterThan_2 = (_size_2 = (_staticCallProperties = element.getStaticCallProperties()).size()) > 0);
        _or = _or_1 ? true : (_greaterThan_3 = (_size_3 = (_defaultChildren = element.getDefaultChildren()).size()) > 0);
        return _or;
    }

    public CharSequence generateMapValueProperty(Property p) {
        StringConcatenation _builder = new StringConcatenation();
        CastHelper _castHelper = new CastHelper();
        ValueProperty _value = p.getValue();
        MapValueProperty list = _castHelper.castToMapValueProperty(_value);
        _builder.newLineIfNotEmpty();
        String _name = p.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" : [");
        _builder.newLineIfNotEmpty();
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<Property> _properties = list.getProperties();
        for (Property inner : _properties) {
            _builder.append((Object)"\t");
            if (comma.booleanValue()) {
                _builder.append((Object)",");
            }
            boolean _or = false;
            String _name_1 = inner.getName();
            boolean _equals = "Integer".equals(_name_1);
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                String _name_2 = inner.getName();
                _or = _equals_1 = "Double".equals(_name_2);
            }
            if (_or) {
                ValuePropertyFormatter _valuePropertyFormatter = new ValuePropertyFormatter(inner);
                String _formattedValue = _valuePropertyFormatter.getFormattedValue();
                _builder.append((Object)_formattedValue, "\t");
            } else {
                String _name_3 = inner.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append((Object)"(");
                ValueProperty _value_1 = inner.getValue();
                ValuePropertyFormatter _valuePropertyFormatter_1 = new ValuePropertyFormatter(_value_1);
                String _formattedValue_1 = _valuePropertyFormatter_1.getFormattedValue();
                _builder.append((Object)_formattedValue_1, "\t");
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            comma = true;
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"]");
        return _builder;
    }

    public CharSequence generateListValueProperty(Property p) {
        StringConcatenation _builder = new StringConcatenation();
        CastHelper _castHelper = new CastHelper();
        ValueProperty _value = p.getValue();
        ListValueProperty list = _castHelper.castToListValueProperty(_value);
        _builder.newLineIfNotEmpty();
        String _name = p.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" : [");
        _builder.newLineIfNotEmpty();
        Boolean comma = false;
        _builder.newLineIfNotEmpty();
        EList<ListValueElement> _value_1 = list.getValue();
        for (ListValueElement e : _value_1) {
            if (comma.booleanValue()) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
            if (e instanceof Element) {
                CharSequence _generateElement = this.generateElement((Element)e);
                _builder.append((Object)_generateElement, "");
            } else {
                ValuePropertyFormatter _valuePropertyFormatter = new ValuePropertyFormatter(e);
                String _formattedValue = _valuePropertyFormatter.getFormattedValue();
                _builder.append((Object)_formattedValue, "");
            }
            _builder.newLineIfNotEmpty();
            comma = true;
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"]");
        return _builder;
    }

    public CharSequence generatePropertyElement(Property p) {
        String _name_1;
        String _firstLower;
        char _charAt_1;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = p.getName();
        char _charAt = _name.charAt(0);
        boolean bl = _equals = _charAt == (_charAt_1 = (_firstLower = StringExtensions.toFirstLower((String)(_name_1 = p.getName()))).charAt(0));
        if (_equals) {
            String _name_2 = p.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" : ");
        }
        CastHelper _castHelper = new CastHelper();
        ValueProperty _value = p.getValue();
        Element _castToElement = _castHelper.castToElement(_value);
        CharSequence _generateElement = this.generateElement(_castToElement);
        _builder.append((Object)_generateElement, "");
        return _builder;
    }

    public CharSequence generateFactory(Element element) {
        EList<FactoryValueElement> _values;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        String _factory = element.getFactory();
        boolean bl = _notEquals = !Objects.equal((Object)_factory, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = (_values = element.getValues()).isEmpty()));
        if (_and) {
            _builder.append((Object)"createdby ");
            String _factory_1 = element.getFactory();
            _builder.append((Object)_factory_1, "");
            _builder.append((Object)" { ");
            _builder.newLineIfNotEmpty();
            Boolean comma = false;
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values_1 = element.getValues();
            for (FactoryValueElement e : _values_1) {
                if (comma.booleanValue()) {
                    _builder.append((Object)",");
                }
                _builder.newLineIfNotEmpty();
                if (e instanceof Element) {
                    CharSequence _generateElement = this.generateElement((Element)e);
                    _builder.append((Object)_generateElement, "");
                    _builder.newLineIfNotEmpty();
                } else {
                    if (e instanceof SimpleValueProperty) {
                        ValuePropertyFormatter _valuePropertyFormatter = new ValuePropertyFormatter(e);
                        String _formattedValue = _valuePropertyFormatter.getFormattedValue();
                        _builder.append((Object)_formattedValue, "");
                    }
                    _builder.newLineIfNotEmpty();
                }
                comma = true;
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
        }
        return _builder;
    }
}

