/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.common.MainMemoryImageData;
import org.eclipse.fx.drift.internal.frontend.AMainMemoryFxImage;
import org.eclipse.fx.drift.internal.prism.PrismES2;

public class ES2MainMemoryFxImage
extends AMainMemoryFxImage {
    private static final DriftLogger LOGGER = DriftFX.createLogger(ES2MainMemoryFxImage.class);

    public ES2MainMemoryFxImage(MainMemoryImageData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uploadTexture() {
        int targetTex = PrismES2.getTextureName(this.getTexture());
        LOGGER.info(() -> "*uploadTexture 0x" + Long.toHexString(((MainMemoryImageData)this.data).memPointer) + " => " + targetTex);
        LOGGER.info(() -> " with Unpack.alignment = " + GL.glGetInteger(3317));
        LOGGER.info(() -> " with Unpack.rowLength = " + GL.glGetInteger(3314));
        MainMemoryImageData mainMemoryImageData = (MainMemoryImageData)this.data;
        synchronized (mainMemoryImageData) {
            this.uploadTexture(targetTex, ((MainMemoryImageData)this.data).size.x, ((MainMemoryImageData)this.data).size.y, ((MainMemoryImageData)this.data).memPointer, ((MainMemoryImageData)this.data).memSize);
        }
    }

    private void uploadTexture(int targetTex, int width, int height, long pPixels, int size) {
        if (targetTex == 0) {
            LOGGER.error(() -> "  !  Invalid Texture ID");
        }
        LOGGER.info(() -> "isTexture(" + targetTex + "): " + GL.glIsTexture(targetTex));
        GL.glPixelStorei(3317, 4);
        GL.glPixelStorei(3314, 0);
        GL.glBindTexture(3553, targetTex);
        GL.glTexImage2D(3553, 0, 32856, width, height, 0, 6408, 33639, pPixels);
        GL.glBindTexture(3553, 0);
    }
}

