/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.srlistener;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.spec.srlistener.ForwardedServlet;
import servlet.tck.spec.srlistener.IncludedServlet;
import servlet.tck.spec.srlistener.SRListener;
import servlet.tck.spec.srlistener.SecondForwardedServlet;
import servlet.tck.spec.srlistener.SecondIncludedServlet;
import servlet.tck.spec.srlistener.TestServlet;

public class SrListenerTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_spec_srlistener_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{ForwardedServlet.class, IncludedServlet.class, SecondForwardedServlet.class, SecondIncludedServlet.class, SRListener.class, TestServlet.class})).setWebXML(SrListenerTests.class.getResource("servlet_spec_srlistener_web.xml"));
    }

    @Test
    public void simpleinclude() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "includes");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "IncludedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void multipleincludes() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "multipleincludes");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "SecondIncludedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void includeforward() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "includeforward");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "ForwardedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void includeerror() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/TestServlet?testname=includeerror HTTP/1.1");
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void simpleforward() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "forward");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "ForwardedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void multipleforwards() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "multipleforwards");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "SecondForwardedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void forwardinclude() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "forwardinclude");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "IncludedServlet Invoked|simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void forwarderror() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/TestServlet?testname=forwarderror HTTP/1.1");
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void simpleasync() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "async");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "TestServlet Invoked|method async|TestServlet_Async=STARTED");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void simpleasyncinclude() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "simpleasyncinclude");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "TestServlet Invoked|method simpleasyncinclude|TestServlet_Async=STARTED|IncludedServlet Invoked||simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void simpleasyncforward() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("apitest", "simpleasyncforward");
            ((Properties)TEST_PROPS.get()).setProperty("search_string", "ForwardedServlet Invoked||simple method");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void simpleasyncerror() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/TestServlet?testname=simpleasyncerror HTTP/1.1");
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }

    @Test
    public void error() throws Exception {
        boolean pass = true;
        try {
            ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/TestServlet?testname=error HTTP/1.1");
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        catch (Exception flt) {
            pass = false;
            this.logger.error("Test failed at the first invocation. catch it here so the cleanup can continue", (Throwable)flt);
        }
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "checkLogSimple");
        this.invoke();
        if (!pass) {
            throw new Exception("Test failed at the first invocation.catch it here so the cleanup can continue");
        }
    }
}

