/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.signature;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.jupiter.api.Test;
import servlet.tck.signature.SigTest;
import servlet.tck.signature.SignatureTestDriver;
import servlet.tck.signature.SignatureTestDriverFactory;

public class ServletSigTest
extends SigTest {
    private static final System.Logger logger = System.getLogger(ServletSigTest.class.getName());

    public ServletSigTest() {
        this.setup();
    }

    @Override
    protected String[] getPackages() {
        return new String[]{"jakarta.servlet", "jakarta.servlet.annotation", "jakarta.servlet.descriptor", "jakarta.servlet.http"};
    }

    @Test
    public void signatureTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "$$$ SigTestIT.signatureTest() called");
        String mapFile = null;
        String packageFile = null;
        Properties mapFileAsProps = null;
        String[] packages = this.getPackages();
        String apiPackage = "jakarta.servlet";
        try {
            InputStream inStreamMapfile = ServletSigTest.class.getClassLoader().getResourceAsStream("servlet/tck/signature/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = ServletSigTest.class.getClassLoader().getResourceAsStream("servlet/tck/signature/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty(apiPackage);
            logger.log(System.Logger.Level.INFO, "Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = ServletSigTest.class.getClassLoader().getResourceAsStream("servlet/tck/signature/jakarta.servlet.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, apiPackage, packageVersion);
            logger.log(System.Logger.Level.INFO, "signature File location is :" + sigFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception while creating temp files :" + ex);
        }
        super.signatureTest(mapFile, packageFile, mapFileAsProps, packages);
    }

    @Override
    protected SignatureTestDriver getSigTestDriver() {
        this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        return this.driver;
    }
}

