/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2;

import com.shapesecurity.salvation2.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class Directive {
    public static Predicate<String> IS_DIRECTIVE_NAME = Pattern.compile("^[A-Za-z0-9\\-]+$").asPredicate();
    public static Predicate<String> containsNonDirectiveCharacter = Pattern.compile("[\t\n\f\r ,;]").asPredicate();
    protected List<String> values = new ArrayList<String>();

    protected static DirectiveErrorConsumer wrapManipulationErrorConsumer(ManipulationErrorConsumer errors) {
        return (severity, message, valueIndex) -> {
            switch (severity) {
                case Info: {
                    errors.add(ManipulationErrorConsumer.Severity.Info, message);
                    break;
                }
                case Warning: {
                    errors.add(ManipulationErrorConsumer.Severity.Warning, message);
                    break;
                }
                case Error: {
                    throw new RuntimeException(message);
                }
                default: {
                    throw new RuntimeException("unreachable: unknown severity " + (Object)((Object)severity));
                }
            }
        };
    }

    protected void addValue(String value) {
        Policy.enforceAscii(value);
        if (containsNonDirectiveCharacter.test(value)) {
            throw new IllegalArgumentException("values must not contain whitespace, ',', or ';'");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("values must not be empty");
        }
        this.values.add(value);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected Directive(List<String> values) {
        for (String value : values) {
            this.addValue(value);
        }
    }

    protected void removeValueIgnoreCase(String value) {
        String lowcaseValue = value.toLowerCase(Locale.ENGLISH);
        ArrayList<String> copy = new ArrayList<String>(this.values.size());
        for (String existing : this.values) {
            if (existing.toLowerCase(Locale.ENGLISH).equals(lowcaseValue)) continue;
            copy.add(existing);
        }
        this.values = copy;
    }

    @FunctionalInterface
    public static interface ManipulationErrorConsumer {
        public static final ManipulationErrorConsumer ignored = (severity, message) -> {};

        public void add(Severity var1, String var2);

        public static enum Severity {
            Info,
            Warning;

        }
    }

    @FunctionalInterface
    public static interface DirectiveErrorConsumer {
        public static final DirectiveErrorConsumer ignored = (severity, message, valueIndex) -> {};

        public void add(Policy.Severity var1, String var2, int var3);
    }
}

