/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.platform.image;

import com.gargoylesoftware.htmlunit.platform.geom.IntDimension2D;
import com.gargoylesoftware.htmlunit.platform.image.ImageData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageIOImageData
implements ImageData {
    private final ImageReader imageReader_;

    public ImageIOImageData(InputStream inputStream) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
        if (!iter.hasNext()) {
            iis.close();
            throw new IOException("No image detected in response");
        }
        ImageReader imageReader = iter.next();
        imageReader.setInput(iis);
        this.imageReader_ = imageReader;
        while (iter.hasNext()) {
            iter.next().dispose();
        }
    }

    public ImageReader getImageReader() {
        return this.imageReader_;
    }

    @Override
    public IntDimension2D getWidthHeight() throws IOException {
        return new IntDimension2D(this.imageReader_.getWidth(0), this.imageReader_.getHeight(0));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.imageReader_ != null) {
            try {
                ImageInputStream stream = (ImageInputStream)this.imageReader_.getInput();
                Throwable throwable = null;
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            finally {
                this.imageReader_.setInput(null);
                this.imageReader_.dispose();
            }
        }
    }
}

