/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.shoal.adapter.store.commands.SimpleAckCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public abstract class AcknowledgedCommand<K, V>
extends Command<K, V> {
    private transient CommandResponse resp;
    private transient Future future;
    private long tokenId;
    private String originatingInstance;

    protected AcknowledgedCommand(byte opCode) {
        super(opCode);
    }

    @Override
    protected boolean beforeTransmit() {
        if (this.dsc.isDoSynchronousReplication()) {
            this.originatingInstance = this.dsc.getInstanceName();
            ResponseMediator respMed = this.dsc.getResponseMediator();
            this.resp = respMed.createCommandResponse();
            this.tokenId = this.resp.getTokenId();
            this.future = this.resp.getFuture();
        }
        return true;
    }

    protected void sendAcknowledgement() {
        try {
            this.dsc.getCommandManager().execute(new SimpleAckCommand(this.originatingInstance, this.tokenId));
        }
        catch (DataStoreException dataStoreException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.dsc.isDoSynchronousReplication());
        if (this.dsc.isDoSynchronousReplication()) {
            out.writeLong(this.tokenId);
            out.writeUTF(this.originatingInstance);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean doSync = in.readBoolean();
        if (doSync) {
            this.tokenId = in.readLong();
            this.originatingInstance = in.readUTF();
        }
    }

    @Override
    public final void onSuccess() {
        if (this.dsc.isDoSynchronousReplication()) {
            try {
                this.waitForAck();
            }
            catch (Exception ex) {
                System.out.println("** Got exception: " + ex);
            }
        }
    }

    @Override
    public final void onFailure() {
        if (this.dsc.isDoSynchronousReplication()) {
            ResponseMediator respMed = this.dsc.getResponseMediator();
            respMed.removeCommandResponse(this.tokenId);
        }
    }

    private void waitForAck() throws DataStoreException, TimeoutException {
        try {
            this.future.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException tEx) {
            throw tEx;
        }
        catch (Exception inEx) {
            throw new DataStoreException(inEx);
        }
        finally {
            ResponseMediator respMed = this.dsc.getResponseMediator();
            respMed.removeCommandResponse(this.tokenId);
        }
    }
}

