/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonparsereventtests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.stream.JsonParser;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonValueOfTest() {
        String[] eventTypeStrings;
        boolean pass = true;
        for (String eventTypeString : eventTypeStrings = new String[]{"END_ARRAY", "END_OBJECT", "KEY_NAME", "START_ARRAY", "START_OBJECT", "VALUE_FALSE", "VALUE_NULL", "VALUE_NUMBER", "VALUE_STRING", "VALUE_TRUE"}) {
            try {
                LOGGER.info("Testing enum value for string constant name " + eventTypeString);
                JsonParser.Event eventType = JsonParser.Event.valueOf((String)eventTypeString);
                LOGGER.info("Got enum type " + eventType + " for enum string constant named " + eventTypeString);
            }
            catch (Exception e) {
                LOGGER.warning("Caught unexpected exception: " + e);
                pass = false;
            }
        }
        LOGGER.info("Testing negative test case for NullPointerException");
        try {
            JsonParser.Event.valueOf(null);
            LOGGER.warning("did not get expected NullPointerException");
            pass = false;
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            LOGGER.warning("Got unexpected exception " + e);
            pass = false;
        }
        LOGGER.info("Testing negative test case for IllegalArgumentException");
        try {
            JsonParser.Event.valueOf((String)"INVALID");
            LOGGER.warning("did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Got expected IllegalArgumentException");
        }
        catch (Exception e) {
            LOGGER.warning("Got unexpected exception " + e);
            pass = false;
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonValueOfTest Failed");
    }

    @Test
    public void jsonValuesTest() {
        JsonParser.Event[] values;
        LOGGER.info("Testing API method JsonParser.Event.values() to return array of enums.");
        for (JsonParser.Event eventType : values = JsonParser.Event.values()) {
            String eventString = JSONP_Util.getEventTypeString((JsonParser.Event)eventType);
            if (eventString == null) {
                Assertions.fail((String)("jsonValuesTest Failed. Got no value for enum " + eventType));
                continue;
            }
            LOGGER.info("Got " + eventString + " for enum " + eventType);
        }
    }
}

