/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.classpath.DirectoryEntry;
import com.sun.tdk.signaturetest.classpath.JarFileEntry;
import com.sun.tdk.signaturetest.classpath.JimageJakeEntry;
import com.sun.tdk.signaturetest.classpath.SigFileEntry;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClasspathImpl
implements Classpath {
    private List<String> errors;
    private int sizeIgnorables;
    private List<ClasspathEntry> entries;
    private Iterator<ClasspathEntry> iterator;
    private ClasspathEntry currentEntry;
    private static String pathSeparator;
    private static I18NResourceBundle i18n;
    private BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);

    public ClasspathImpl(String classPath) {
        this.init(classPath);
    }

    @Override
    public void init(String classPath) {
        String path;
        this.entries = new ArrayList<ClasspathEntry>();
        this.errors = new ArrayList<String>();
        HashSet<String> unique = new HashSet<String>();
        String string = path = classPath == null ? "" : classPath;
        if (!path.equals("") && pathSeparator == null) {
            throw new SecurityException(i18n.getString("ClasspathImpl.error.notdefinepathsep"));
        }
        ClasspathEntry previosEntry = null;
        while (path != null && path.length() > 0) {
            String s;
            int index = path.indexOf(pathSeparator);
            if (index < 0) {
                s = path;
                path = null;
            } else {
                s = path.substring(0, index);
                path = path.substring(index + pathSeparator.length());
            }
            if (unique.contains(s)) {
                this.errors.add(i18n.getString("ClasspathImpl.error.duplicate_entry_found", s));
                continue;
            }
            unique.add(s);
            ClasspathEntry entry = this.createPathEntry(previosEntry, s);
            if (entry == null || entry.isEmpty()) continue;
            this.entries.add(entry);
            previosEntry = entry;
        }
        this.setListToBegin();
    }

    @Override
    public void close() {
        if (this.entries != null) {
            for (ClasspathEntry ce : this.entries) {
                ce.close();
            }
            this.entries = null;
            this.iterator = null;
            this.currentEntry = null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public void printErrors(PrintWriter out) {
        if (out != null) {
            for (String err : this.errors) {
                out.println(err);
            }
        }
    }

    public int getNumErrors() {
        return this.errors.size() - this.sizeIgnorables;
    }

    @Override
    public void setListToBegin() {
        this.iterator = this.entries.iterator();
        this.currentEntry = null;
        if (this.iterator.hasNext()) {
            this.currentEntry = this.iterator.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentEntry == null) {
            return false;
        }
        if (this.currentEntry.hasNext()) {
            return true;
        }
        this.currentEntry = null;
        if (this.iterator.hasNext()) {
            this.currentEntry = this.iterator.next();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public String nextClassName() {
        return this.currentEntry.nextClassName();
    }

    @Override
    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        name = ExoticCharTools.decodeExotic(name);
        assert (name.indexOf(60) == -1 && name.indexOf(62) == -1);
        Iterator<ClasspathEntry> e = this.entries.iterator();
        while (e.hasNext()) {
            try {
                return e.next().findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public ClassDescription findClassDescription(String qualifiedClassName) throws ClassNotFoundException {
        for (ClasspathEntry ce : this.entries) {
            try {
                if (!(ce instanceof ClassDescriptionLoader)) continue;
                return ((ClassDescriptionLoader)((Object)ce)).load(qualifiedClassName);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(qualifiedClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classpath.KIND_CLASS_DATA isClassPresent(String qualifiedClassName) {
        try {
            this.findClassDescription(qualifiedClassName);
            return Classpath.KIND_CLASS_DATA.DESCRIPTION;
        }
        catch (Exception cnfe) {
            InputStream is = null;
            try {
                is = this.findClass(qualifiedClassName);
                Classpath.KIND_CLASS_DATA kIND_CLASS_DATA = Classpath.KIND_CLASS_DATA.BYTE_CODE;
                return kIND_CLASS_DATA;
            }
            catch (Exception e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            return Classpath.KIND_CLASS_DATA.NOT_FOUND;
        }
    }

    protected ClasspathEntry createPathEntry(ClasspathEntry previosEntry, String name) {
        try {
            if (new File(name).isDirectory()) {
                return new DirectoryEntry(previosEntry, name);
            }
            if (new File(name).getName().equals("modules") || name.endsWith(".jimage")) {
                return new JimageJakeEntry(previosEntry, name);
            }
            if (this.isSigFile(name)) {
                return new SigFileEntry(previosEntry, name);
            }
            return new JarFileEntry(previosEntry, name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private boolean isSigFile(String fName) {
        return fName.toLowerCase().endsWith(".sig");
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(ClasspathImpl.class);
        try {
            Class<?> c = Class.forName("java.io.File");
            Field f = c.getField("pathSeparator");
            pathSeparator = (String)f.get(null);
        }
        catch (Throwable t) {
            try {
                pathSeparator = System.getProperty("path.separator");
            }
            catch (SecurityException e) {
                SwissKnife.reportThrowable(e);
            }
        }
    }
}

