/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionMetaData;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.Record;
import jakarta.resource.cci.RecordFactory;
import java.io.Serializable;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;

public class EISAccessor
extends DatasourceAccessor {
    protected Connection cciConnection;
    protected RecordFactory recordFactory;

    @Override
    protected void basicBeginTransaction(AbstractSession session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().begin();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    @Override
    protected void closeDatasourceConnection() {
        try {
            this.getCCIConnection().close();
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, null);
        }
    }

    @Override
    protected void basicCommitTransaction(AbstractSession session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().commit();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    @Override
    protected void buildConnectLog(AbstractSession session) {
        try {
            if (session.shouldLog(4, "connection")) {
                ConnectionMetaData metaData = this.getCCIConnection().getMetaData();
                Object[] args = new Object[]{metaData.getUserName(), metaData.getEISProductName(), metaData.getEISProductVersion(), Helper.cr(), "\t"};
                session.log(4, "connection", "connected_user_database", args, this);
            }
        }
        catch (ResourceException exception) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        boolean autoCommit;
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        Interaction interaction = null;
        Serializable result = null;
        EISInteraction eisCall = null;
        try {
            eisCall = (EISInteraction)call;
        }
        catch (ClassCastException e) {
            throw QueryException.invalidDatabaseCall(call);
        }
        boolean bl = autoCommit = !this.isInTransaction() && this.getEISPlatform().requiresAutoCommit();
        if (autoCommit) {
            this.beginTransaction(session);
        }
        try {
            if (session.shouldLog(3, "sql")) {
                session.log(3, "sql", call.getLogString(this), null, this, false);
            }
            this.incrementCallCount(session);
            session.startOperationProfile("Timer:SqlPrepare", eisCall.getQuery(), Integer.MAX_VALUE);
            Record input = null;
            Record output = null;
            try {
                interaction = this.getCCIConnection().createInteraction();
                input = this.getEISPlatform().createInputRecord(eisCall, this);
                output = this.getEISPlatform().createOutputRecord(eisCall, translationRow, this);
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", eisCall.getQuery(), Integer.MAX_VALUE);
            }
            session.startOperationProfile("Timer:StatementExecute", eisCall.getQuery(), Integer.MAX_VALUE);
            try {
                boolean success = true;
                InteractionSpec interactionSpec = this.getEISPlatform().buildInteractionSpec(eisCall);
                if (output == null) {
                    output = interaction.execute(interactionSpec, input);
                } else {
                    success = interaction.execute(interactionSpec, input, output);
                }
                session.log(1, "query", "adapter_result", output);
                if (eisCall.isNothingReturned()) {
                    AbstractRecord outputRow;
                    result = success ? Integer.valueOf(1) : Integer.valueOf(0);
                    if (output != null && (outputRow = this.getEISPlatform().buildRow(output, eisCall, this)) != null) {
                        eisCall.getQuery().setProperty("output", outputRow);
                        if (session.hasEventManager()) {
                            session.getEventManager().outputParametersDetected(outputRow, eisCall);
                        }
                    }
                } else {
                    result = eisCall.isOneRowReturned() ? this.getEISPlatform().buildRow(output, eisCall, this) : this.getEISPlatform().buildRows(output, eisCall, this);
                }
                session.log(1, "query", "data_access_result", output);
            }
            finally {
                session.endOperationProfile("Timer:StatementExecute", eisCall.getQuery(), Integer.MAX_VALUE);
            }
        }
        catch (ResourceException exception) {
            if (interaction != null) {
                try {
                    interaction.close();
                }
                catch (Exception output) {
                    // empty catch block
                }
            }
            try {
                this.decrementCallCount();
            }
            catch (Exception output) {
                // empty catch block
            }
            try {
                if (autoCommit) {
                    this.commitTransaction(session);
                }
            }
            catch (Exception output) {
                // empty catch block
            }
            throw EISException.resourceException(exception, call, this, session);
        }
        catch (RuntimeException exception) {
            try {
                try {
                    if (interaction != null) {
                        interaction.close();
                    }
                }
                finally {
                    if (autoCommit) {
                        this.commitTransaction(session);
                    }
                }
            }
            catch (Exception output) {
                // empty catch block
            }
            throw exception;
        }
        boolean transactionCommitted = false;
        boolean countDecremented = false;
        try {
            interaction.close();
            if (autoCommit) {
                this.commitTransaction(session);
            }
            transactionCommitted = true;
            this.decrementCallCount();
            countDecremented = true;
        }
        catch (ResourceException exception) {
            try {
                if (!transactionCommitted && autoCommit) {
                    this.commitTransaction(session);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (!countDecremented) {
                    this.decrementCallCount();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw EISException.resourceException(exception, this, session);
        }
        return result;
    }

    public Connection getCCIConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public EISPlatform getEISPlatform() {
        return (EISPlatform)this.getDatasourcePlatform();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    @Override
    public void basicRollbackTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().rollback();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    @Override
    protected boolean isDatasourceConnected() {
        return this.isConnected;
    }
}

