/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.apache.felix.eventadmin.impl.util.Matchers;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class EventHandlerTracker
extends ServiceTracker<EventHandler, EventHandlerProxy> {
    private final List<EventHandlerProxy> matchingAllEvents = new CopyOnWriteArrayList<EventHandlerProxy>();
    private final Map<String, List<EventHandlerProxy>> matchingTopic = new ConcurrentHashMap<String, List<EventHandlerProxy>>();
    private final Map<String, List<EventHandlerProxy>> matchingPrefixTopic = new ConcurrentHashMap<String, List<EventHandlerProxy>>();
    private HandlerContext handlerContext;

    public EventHandlerTracker(BundleContext context) {
        super(context, EventHandler.class.getName(), null);
    }

    public void update(String[] ignoreTimeout, boolean requireTopic) {
        Matchers.Matcher[] ignoreTimeoutMatcher = Matchers.createPackageMatchers(ignoreTimeout);
        this.handlerContext = new HandlerContext(this.context, ignoreTimeoutMatcher, requireTopic);
    }

    public EventHandlerProxy addingService(ServiceReference<EventHandler> reference) {
        EventHandlerProxy proxy = new EventHandlerProxy(this.handlerContext, reference);
        if (proxy.update()) {
            this.put(proxy);
        }
        return proxy;
    }

    public void modifiedService(ServiceReference<EventHandler> reference, EventHandlerProxy proxy) {
        this.remove(proxy);
        if (proxy.update()) {
            this.put(proxy);
        }
    }

    public void removedService(ServiceReference<EventHandler> reference, EventHandlerProxy proxy) {
        this.remove(proxy);
        proxy.dispose();
    }

    private void updateMap(Map<String, List<EventHandlerProxy>> proxyListMap, String key, EventHandlerProxy proxy, boolean add) {
        List<EventHandlerProxy> proxies = proxyListMap.get(key);
        if (proxies == null) {
            if (!add) {
                return;
            }
            proxies = new CopyOnWriteArrayList<EventHandlerProxy>();
            proxyListMap.put(key, proxies);
        }
        if (add) {
            proxies.add(proxy);
        } else {
            proxies.remove(proxy);
            if (proxies.size() == 0) {
                proxyListMap.remove(key);
            }
        }
    }

    private synchronized void put(EventHandlerProxy proxy) {
        String[] topics = proxy.getTopics();
        if (topics == null) {
            this.matchingAllEvents.add(proxy);
        } else {
            for (int i = 0; i < topics.length; ++i) {
                String topic = topics[i];
                if (topic.endsWith("/*")) {
                    String prefix = topic.substring(0, topic.length() - 2);
                    this.updateMap(this.matchingPrefixTopic, prefix, proxy, true);
                    continue;
                }
                this.updateMap(this.matchingTopic, topic, proxy, true);
            }
        }
    }

    private synchronized void remove(EventHandlerProxy proxy) {
        String[] topics = proxy.getTopics();
        if (topics == null) {
            this.matchingAllEvents.remove(proxy);
        } else {
            for (int i = 0; i < topics.length; ++i) {
                String topic = topics[i];
                if (topic.endsWith("/*")) {
                    String prefix = topic.substring(0, topic.length() - 2);
                    this.updateMap(this.matchingPrefixTopic, prefix, proxy, false);
                    continue;
                }
                this.updateMap(this.matchingTopic, topic, proxy, false);
            }
        }
    }

    public Collection<EventHandlerProxy> getHandlers(Event event) {
        String topic = event.getTopic();
        HashSet<EventHandlerProxy> handlers = new HashSet<EventHandlerProxy>();
        this.checkHandlerAndAdd(handlers, this.matchingAllEvents, event);
        if (!this.matchingPrefixTopic.isEmpty()) {
            int pos = topic.lastIndexOf(47);
            while (pos != -1) {
                String prefix = topic.substring(0, pos);
                this.checkHandlerAndAdd(handlers, this.matchingPrefixTopic.get(prefix), event);
                pos = prefix.lastIndexOf(47);
            }
        }
        this.checkHandlerAndAdd(handlers, this.matchingTopic.get(topic), event);
        return handlers;
    }

    public Collection<EventHandlerProxy> getDeniedHandlers() {
        HashSet<EventHandlerProxy> handlers = new HashSet<EventHandlerProxy>();
        for (EventHandlerProxy eventHandlerProxy : this.matchingAllEvents) {
            if (!eventHandlerProxy.isDenied()) continue;
            handlers.add(eventHandlerProxy);
        }
        for (List list : this.matchingPrefixTopic.values()) {
            for (EventHandlerProxy p : list) {
                if (!p.isDenied()) continue;
                handlers.add(p);
            }
        }
        for (List list : this.matchingTopic.values()) {
            for (EventHandlerProxy p : list) {
                if (!p.isDenied()) continue;
                handlers.add(p);
            }
        }
        return handlers;
    }

    private void checkHandlerAndAdd(Set<EventHandlerProxy> handlers, List<EventHandlerProxy> proxies, Event event) {
        if (proxies != null) {
            for (EventHandlerProxy p : proxies) {
                if (!p.canDeliver(event)) continue;
                handlers.add(p);
            }
        }
    }

    static final class HandlerContext {
        public final BundleContext bundleContext;
        public final Matchers.Matcher[] ignoreTimeoutMatcher;
        public final boolean requireTopic;

        public HandlerContext(BundleContext bundleContext, Matchers.Matcher[] ignoreTimeoutMatcher, boolean requireTopic) {
            this.bundleContext = bundleContext;
            this.ignoreTimeoutMatcher = ignoreTimeoutMatcher;
            this.requireTopic = requireTopic;
        }
    }
}

