/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.descriptors.CoreInstantiationPolicy;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class InstantiationPolicy
extends CoreInstantiationPolicy
implements Cloneable,
Serializable {
    protected String methodName;
    protected transient Method method;
    protected Class<?> factoryClass;
    protected String factoryClassName;
    protected String factoryMethodName;
    protected Object factory;
    protected ClassDescriptor descriptor;
    private transient Constructor defaultConstructor;

    @Override
    public Object buildNewInstance() throws DescriptorException {
        if (this.methodName == null) {
            return this.buildNewInstanceUsingDefaultConstructor();
        }
        return this.buildNewInstanceUsingFactory();
    }

    protected Object buildNewInstanceUsingDefaultConstructor() throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithThrowable(() -> (this.defaultConstructor != null ? this.defaultConstructor : this.getDefaultConstructor()).newInstance(null), t -> {
            if (t instanceof DescriptorException) {
                return (DescriptorException)t;
            }
            if (t instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileConstructorInstantiation(this.getDescriptor(), (InvocationTargetException)t);
            }
            if (t instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileConstructorInstantiation(this.getDescriptor(), (IllegalAccessException)t);
            }
            if (t instanceof InstantiationException) {
                return DescriptorException.instantiationWhileConstructorInstantiation(this.getDescriptor(), (InstantiationException)t);
            }
            if (t instanceof NoSuchMethodError) {
                return DescriptorException.noSuchMethodWhileConstructorInstantiation(this.getDescriptor(), t);
            }
            if (t instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileConstructorInstantiation(this.getDescriptor(), t);
            }
            return new RuntimeException(String.format("Invocation of default %s constructor failed", this.getDescriptor().getJavaClass().getName()), t);
        });
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(this.getMethod(), this.getFactory(), new Object[0]), ex -> {
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            if (ex instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            if (ex instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            return new RuntimeException(String.format("Invocation of factory %s class %s method failed", this.getFactory().getClass().getName(), this.getMethod().getName()), ex);
        });
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Constructor getDefaultConstructor() throws DescriptorException {
        if (this.defaultConstructor == null) {
            this.setDefaultConstructor(this.buildDefaultConstructor());
        }
        return this.defaultConstructor;
    }

    protected Constructor buildDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getDescriptor().getJavaClass());
    }

    protected Constructor buildDefaultConstructorFor(Class<?> javaClass) throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getDeclaredConstructorFor(javaClass, new Class[0], true), ex -> DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(javaClass.getName() + ".<Default Constructor>", this.getDescriptor(), ex));
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public Object getFactory() {
        return this.factory;
    }

    public Class<?> getFactoryClass() {
        return this.factoryClass;
    }

    public String getFactoryClassName() {
        if (this.factoryClassName == null && this.factoryClass != null) {
            this.factoryClassName = this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    protected Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isUsingDefaultConstructor()) {
            return;
        }
        try {
            this.initializeMethod();
            if (!Modifier.isStatic(this.getMethod().getModifiers()) && this.getFactory() == null) {
                this.setFactory(this.buildFactory());
            }
        }
        catch (DescriptorException ex) {
            session.getIntegrityChecker().handleError(ex);
        }
    }

    protected Object buildFactory() throws DescriptorException {
        if (this.getFactoryClass() == null) {
            return null;
        }
        if (this.getFactoryMethodName() == null) {
            return this.buildFactoryUsingDefaultConstructor();
        }
        return this.buildFactoryUsingStaticMethod();
    }

    protected Object buildFactoryUsingDefaultConstructor() throws DescriptorException {
        Constructor factoryDefaultConstructor = this.buildFactoryDefaultConstructor();
        return PrivilegedAccessHelper.callDoPrivilegedWithThrowable(() -> PrivilegedAccessHelper.invokeConstructor(factoryDefaultConstructor, null), t -> {
            if (t instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileConstructorInstantiationOfFactory(this.getDescriptor(), (InvocationTargetException)t);
            }
            if (t instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileConstructorInstantiationOfFactory(this.getDescriptor(), (IllegalAccessException)t);
            }
            if (t instanceof InstantiationException) {
                return DescriptorException.instantiationWhileConstructorInstantiationOfFactory(this.getDescriptor(), (InstantiationException)t);
            }
            if (t instanceof NoSuchMethodError) {
                return DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory(this.getDescriptor(), t);
            }
            if (t instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileConstructorInstantiationOfFactory(this.getDescriptor(), t);
            }
            return new RuntimeException(String.format("Invocation of %s factory constructor failed", this.factoryClassName), t);
        });
    }

    protected Constructor buildFactoryDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getFactoryClass());
    }

    protected Object buildFactoryUsingStaticMethod() throws DescriptorException {
        Method factoryMethod = this.buildMethod(this.getFactoryClass(), this.factoryMethodName, new Class[0]);
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(factoryMethod, null, null), ex -> {
            String factoryMethodName = this.getFactoryMethodName();
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileMethodInstantiationOfFactory(factoryMethodName, this.getDescriptor(), ex);
            }
            if (ex instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileMethodInstantiationOfFactory(factoryMethodName, this.getDescriptor(), ex);
            }
            if (ex instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileMethodInstantiationOfFactory(factoryMethodName, this.getDescriptor(), ex);
            }
            return new RuntimeException(String.format("Invocation of %s factory method failed", factoryMethodName), ex);
        });
    }

    protected void initializeMethod() throws DescriptorException {
        Class<Object> tempClass = this.getFactory() != null ? this.getFactory().getClass() : (this.getFactoryClass() == null ? this.getDescriptor().getJavaClass() : this.getFactoryClass());
        this.setMethod(this.buildMethod(tempClass, this.getMethodName(), new Class[0]));
    }

    protected Method buildMethod(Class<?> methodClass, String methodName, Class<?>[] methodParameterTypes) throws DescriptorException {
        try {
            return Helper.getDeclaredMethod(methodClass, methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(methodClass.getName() + "." + methodName, this.getDescriptor(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingInstantiationPolicy(methodClass.getName() + "." + methodName, this.getDescriptor(), exception);
        }
    }

    public boolean isUsingDefaultConstructor() {
        return this.getMethodName() == null;
    }

    protected void setDefaultConstructor(Constructor defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    protected void setFactory(Object factory) {
        this.factory = factory;
    }

    protected void setFactoryClass(Class<?> factoryClass) {
        this.factoryClass = factoryClass;
    }

    protected void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.factoryClassName == null) {
            return;
        }
        this.setFactoryClass(PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.factoryClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.factoryClassName, ex)));
    }

    public String toString() {
        String mName = null;
        mName = this.isUsingDefaultConstructor() ? "<CONSTRUCTOR>" : this.getMethodName();
        return this.getClass().getSimpleName() + "(" + mName + ")";
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.setMethodName(null);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class<?> factoryClass, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(factoryClass);
        this.setFactoryClassName(factoryClass.getName());
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class<?> factoryClass, String methodName, String factoryMethodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(factoryClass);
        this.setFactoryClassName(factoryClass.getName());
        this.setFactoryMethodName(factoryMethodName);
    }

    @Override
    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(factoryClassName);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(factoryClassName);
        this.setFactoryMethodName(factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(factory);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.setMethodName(staticMethodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }
}

