/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtil {
    public static String expandVariables(String str, Properties props) {
        if (str == null) {
            return str;
        }
        String value = null;
        int len = str.length();
        StringBuilder sbuf = null;
        int vend = 0;
        int vstart = 0;
        int current = 0;
        while (current < len) {
            String vname;
            vstart = str.indexOf(36, current);
            if (vstart == -1) {
                if (sbuf == null) break;
                sbuf.append(str.substring(current, len));
                break;
            }
            if (str.charAt(vstart + 1) == '{' && (vend = str.indexOf(125, vstart + 1)) == -1) {
                if (sbuf == null) break;
                sbuf.append(str.substring(current, len));
                break;
            }
            if (sbuf == null) {
                sbuf = new StringBuilder(2 * len);
            }
            if (vend > vstart) {
                vname = str.substring(vstart + 2, vend);
            } else {
                vname = null;
                vend = vstart;
            }
            if (vname == null) {
                value = null;
            } else if (vname.equals("/")) {
                value = System.getProperty("file.separator");
            } else if (vname.equals("NL")) {
                value = System.getProperty("line.separator");
            } else if (props != null) {
                value = props.getProperty(vname);
            }
            sbuf.append(str.substring(current, vstart));
            if (value == null) {
                sbuf.append(str.substring(vstart, vend + 1));
            } else {
                sbuf.append(value);
            }
            current = vend + 1;
        }
        if (sbuf != null) {
            return sbuf.toString();
        }
        return str;
    }

    public static Properties toProperties(String keyvalPairs, Properties props) {
        return StringUtil.toProperties(keyvalPairs, ",", props);
    }

    public static Properties toProperties(String keyvalPairs, String separator, Properties p) {
        Properties props = p;
        if (props == null) {
            props = new Properties();
        }
        if (keyvalPairs == null) {
            return props;
        }
        List<String> pairs = StringUtil.breakToList(keyvalPairs, separator);
        for (String pair : pairs) {
            List<String> l = StringUtil.breakToList(pair, "=");
            if (l.size() != 2) {
                throw new IllegalArgumentException("Invalid property element: " + pair);
            }
            props.setProperty(l.get(0), l.get(1));
        }
        return props;
    }

    static List<String> breakToList(String value, String separator) {
        StringTokenizer token = new StringTokenizer(value, separator, false);
        ArrayList<String> retv = new ArrayList<String>();
        while (token.hasMoreElements()) {
            int start;
            String newtoken = token.nextToken();
            newtoken = newtoken.trim();
            for (start = 0; start < newtoken.length() && Character.isSpaceChar(newtoken.charAt(start)); ++start) {
            }
            if (start > 0) {
                newtoken = newtoken.substring(start + 1);
            }
            if (newtoken.trim().length() <= 0) continue;
            retv.add(newtoken.trim());
        }
        return retv;
    }
}

