/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.CMRFieldInfo;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;

public class NameMapper
extends com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper {
    private static String EJB_NAME = "EJB_NAME";
    private static String ABSTRACT_SCHEMA_NAME = "ABSTRACT_SCHEMA_NAME";
    private static String PERSISTENCE_NAME = "PERSISTENCE_NAME";
    private static String LOCAL_NAME = "LOCAL_NAME";
    private static String REMOTE_NAME = "REMOTE_NAME";
    private final boolean _expandPCNames;
    private Map _nameTypeToNameMap;
    public static final String SIGNATURE = "$RCSfile: NameMapper.java,v $ $Revision: 1.2 $";

    public NameMapper(EjbBundleDescriptorImpl bundleDescriptor) {
        this(bundleDescriptor, true);
    }

    public NameMapper(EjbBundleDescriptorImpl bundleDescriptor, boolean expandPersistenceClassNames) {
        super(bundleDescriptor);
        this._expandPCNames = expandPersistenceClassNames;
        this.initMap();
    }

    private void initMap() {
        Iterator iterator = this.getBundleDescriptor().getEjbs().iterator();
        HashMap<String, IASEjbCMPEntityDescriptor> ejbMap = new HashMap<String, IASEjbCMPEntityDescriptor>();
        HashMap persistenceClassMap = new HashMap();
        HashSet localNames = new HashSet();
        HashSet remoteNames = new HashSet();
        HashMap abstractSchemaMap = new HashMap();
        this._nameTypeToNameMap = new HashMap();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IASEjbCMPEntityDescriptor)) continue;
            IASEjbCMPEntityDescriptor descriptor = (IASEjbCMPEntityDescriptor)next;
            String ejbName = descriptor.getName();
            ejbMap.put(ejbName, descriptor);
            this.safePut(persistenceClassMap, this.getPersistenceClassForDescriptor((EjbCMPEntityDescriptor)descriptor), ejbName);
            this.safeAdd(localNames, descriptor.getLocalClassName());
            this.safeAdd(remoteNames, descriptor.getRemoteClassName());
            this.safePut(abstractSchemaMap, descriptor.getAbstractSchemaName(), ejbName);
        }
        this._nameTypeToNameMap.put(EJB_NAME, ejbMap);
        this._nameTypeToNameMap.put(PERSISTENCE_NAME, persistenceClassMap);
        this._nameTypeToNameMap.put(LOCAL_NAME, localNames);
        this._nameTypeToNameMap.put(REMOTE_NAME, remoteNames);
        this._nameTypeToNameMap.put(ABSTRACT_SCHEMA_NAME, abstractSchemaMap);
    }

    private void safePut(Map map, Object key, Object value) {
        if (key != null && map != null) {
            map.put(key, value);
        }
    }

    private void safeAdd(Set set, Object value) {
        if (value != null && set != null) {
            set.add(value);
        }
    }

    private Map getMap() {
        return this._nameTypeToNameMap;
    }

    public boolean isEjbName(String name) {
        return this.mapContainsKey(EJB_NAME, name);
    }

    @Override
    public EjbCMPEntityDescriptor getDescriptorForEjbName(String name) {
        Map ejbMap = (Map)this.getMap().get(EJB_NAME);
        Object descriptor = ejbMap.get(name);
        return descriptor != null && descriptor instanceof EjbCMPEntityDescriptor ? (EjbCMPEntityDescriptor)descriptor : null;
    }

    private IASEjbCMPEntityDescriptor getIASDescriptorForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null && descriptor instanceof IASEjbCMPEntityDescriptor ? (IASEjbCMPEntityDescriptor)descriptor : null;
    }

    public String getAbstractBeanClassForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? descriptor.getEjbClassName() : null;
    }

    public String getKeyClassForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? descriptor.getPrimaryKeyClassName() : null;
    }

    @Override
    public String getEjbNameForAbstractSchema(String schemaName) {
        Map abstractSchemaMap = (Map)this.getMap().get(ABSTRACT_SCHEMA_NAME);
        return (String)abstractSchemaMap.get(schemaName);
    }

    public String getAbstractSchemaForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? descriptor.getAbstractSchemaName() : null;
    }

    @Override
    public String getConcreteBeanClassForEjbName(String name) {
        IASEjbCMPEntityDescriptor descriptor = this.getIASDescriptorForEjbName(name);
        return descriptor != null ? this.getQualifiedName(this.getAbstractBeanClassForEjbName(name), descriptor.getConcreteImplClassName()) : null;
    }

    private String getQualifiedName(String classNameWithPackage, String classNameToQualify) {
        String packageName;
        if (!StringHelper.isEmpty((String)classNameToQualify) && StringHelper.isEmpty((String)(packageName = JavaTypeHelper.getPackageName((String)classNameToQualify))) && !StringHelper.isEmpty((String)(packageName = JavaTypeHelper.getPackageName((String)classNameWithPackage)))) {
            return packageName + "." + classNameToQualify;
        }
        return classNameToQualify;
    }

    public String getEjbNameForPersistenceClass(String className) {
        Map pcMap = (Map)this.getMap().get(PERSISTENCE_NAME);
        return (String)pcMap.get(className);
    }

    public String getPersistenceClassForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? this.getPersistenceClassForDescriptor(descriptor) : null;
    }

    private String getPersistenceClassForDescriptor(EjbCMPEntityDescriptor descriptor) {
        Object pcName;
        Object object = pcName = descriptor instanceof IASEjbCMPEntityDescriptor ? ((IASEjbCMPEntityDescriptor)descriptor).getPcImplClassName() : null;
        if (pcName != null && !this._expandPCNames) {
            pcName = JavaTypeHelper.getPackageName((String)pcName) + "." + descriptor.getName();
        }
        return pcName;
    }

    private boolean mapContainsKey(String stringIndex, String name) {
        Object mapObject = this.getMap().get(stringIndex);
        Set testSet = mapObject instanceof Set ? (Set)mapObject : ((Map)mapObject).keySet();
        return name != null ? testSet.contains(name) : false;
    }

    public boolean isLocalInterface(String name) {
        return this.mapContainsKey(LOCAL_NAME, name);
    }

    public String getEjbNameForLocalInterface(String ejbName, String fieldName, String interfaceName) {
        EjbCMPEntityDescriptor descriptor = this.getRelatedEjbDescriptor(ejbName, fieldName);
        return descriptor != null && !StringHelper.isEmpty((String)interfaceName) && interfaceName.equals(descriptor.getLocalClassName()) ? descriptor.getName() : null;
    }

    public String getLocalInterfaceForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? descriptor.getLocalClassName() : null;
    }

    public boolean isRemoteInterface(String name) {
        return this.mapContainsKey(REMOTE_NAME, name);
    }

    public String getEjbNameForRemoteInterface(String ejbName, String fieldName, String interfaceName) {
        EjbCMPEntityDescriptor descriptor = this.getRelatedEjbDescriptor(ejbName, fieldName);
        return descriptor != null && !StringHelper.isEmpty((String)interfaceName) && interfaceName.equals(descriptor.getRemoteClassName()) ? descriptor.getName() : null;
    }

    public String getRemoteInterfaceForEjbName(String name) {
        EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
        return descriptor != null ? descriptor.getRemoteClassName() : null;
    }

    private EjbCMPEntityDescriptor getRelatedEjbDescriptor(String ejbName, String ejbFieldName) {
        EjbCMPEntityDescriptor descriptor;
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = descriptor = ejbName != null ? this.getDescriptorForEjbName(ejbName) : null;
        if (descriptor != null) {
            PersistenceDescriptor persistenceDescriptor = descriptor.getPersistenceDescriptor();
            CMRFieldInfo cmrf = persistenceDescriptor.getCMRFieldInfoByName(ejbFieldName);
            return cmrf.role.getPartner().getOwner();
        }
        return null;
    }

    public String getEjbFieldForPersistenceField(String className, String fieldName) {
        return fieldName;
    }

    public String getPersistenceFieldForEjbField(String name, String fieldName) {
        return fieldName;
    }
}

