/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.io.InputStream;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserInformation;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CustomConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Error;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Order;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.OrderLine;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.SuperUser;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.TestGroup;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.UserType;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class XmlConfigurationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)XmlConfigurationTest.webArchiveBuilder().withTestClass(XmlConfigurationTest.class)).withClasses(User.class, UserType.class, Error.class, ConsistentUserInformation.class, ConsistentUserValidator.class, CustomConsistentUserValidator.class, Optional.class, Order.class, OrderLine.class, CreditCard.class, TestGroup.class, SuperUser.class)).withValidationXml("validation-XmlConfigurationTest.xml")).withResource("user-constraints.xml")).withResource("superuser-constraints.xml")).withResource("order-constraints.xml")).withResource("order-constraints-XmlConfigurationTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testClassConstraintDefinedInXml() {
        User user = new User();
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[]{TestGroup.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ConsistentUserInformation.class).withMessage("Message from xml"));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Set payloads = constraintViolation.getConstraintDescriptor().getPayload();
        Assert.assertTrue((payloads.size() == 1 ? 1 : 0) != 0, (String)"One one payload class is defined in xml");
        Assert.assertTrue((boolean)Error.class.equals(payloads.iterator().next()));
        user.setConsistent(true);
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testIgnoreValidationXml() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Validator validator = config.ignoreXmlConfiguration().buildValidatorFactory().getValidator();
        Order order = new Order();
        Set constraintViolations = this.getValidator().validate((Object)order, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testPropertyConstraintDefinedInXml() {
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfeschlegelsteinhausenbergerdorff");
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("Size is limited!"));
        user.setFirstname("Wolfgang");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testFieldConstraintDefinedInXml() {
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfgang");
        user.setLastname("doe");
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withMessage("Last name has to start with with a capital letter."));
        user.setLastname("Doe");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testAnnotationDefinedConstraintApplies() {
        User user = new User();
        user.setConsistent(true);
        user.setPhoneNumber("police");
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withMessage("A phone number can only contain numbers, whitespaces and dashes."));
        user.setPhoneNumber("112");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="a"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="r"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="s"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="a")})
    public void testCascadingConfiguredInXml() {
        User user = new User();
        user.setConsistent(true);
        CreditCard card = new CreditCard();
        card.setNumber("not a number");
        user.setCreditcard(card);
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withMessage("Not a credit card number."));
        card.setNumber("1234567890");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="t")
    public void testMappingFilesAddedViaConfigurationGetAddedToXmlConfiguredMappings() {
        Assert.assertFalse((boolean)this.getValidator().getConstraintsForClass(Order.class).isBeanConstrained(), (String)"Without additional mapping Order should be unconstrained");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(this.getStream("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/order-constraints-XmlConfigurationTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Assert.assertTrue((boolean)validator.getConstraintsForClass(Order.class).isBeanConstrained(), (String)"With additional mapping Order should be constrained");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="d"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="e"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="g"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-constraintdeclaration", id="h"), @SpecAssertion(section="xml-mapping-typeconversion", id="a"), @SpecAssertion(section="xml-mapping-typeconversion", id="b"), @SpecAssertion(section="xml-mapping-typeconversion", id="c"), @SpecAssertion(section="xml-mapping-typeconversion", id="d"), @SpecAssertion(section="xml-mapping-typeconversion", id="e"), @SpecAssertion(section="xml-mapping-typeconversion", id="f"), @SpecAssertion(section="xml-mapping-typeconversion", id="g"), @SpecAssertion(section="xml-mapping-typeconversion", id="h"), @SpecAssertion(section="xml-mapping-typeconversion", id="i"), @SpecAssertion(section="xml-mapping-typeconversion", id="j"), @SpecAssertion(section="xml-mapping-typeconversion", id="k")})
    public void testElementConversionInXmlConfiguredConstraint() {
        BeanDescriptor beanDescriptor = this.getValidator().getConstraintsForClass(User.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        Set constraintDescriptors = beanDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals((String)descriptor.getMessageTemplate(), (String)"Message from xml");
        Assert.assertEquals((Set)descriptor.getGroups(), TestUtil.asSet(TestGroup.class));
        Assert.assertEquals((Set)descriptor.getPayload(), TestUtil.asSet(Error.class));
        ConsistentUserInformation constraintAnnotation = (ConsistentUserInformation)descriptor.getAnnotation();
        Assert.assertEquals((byte)constraintAnnotation.byteParam(), (byte)127, (String)"Wrong parameter value");
        Assert.assertEquals((short)constraintAnnotation.shortParam(), (short)Short.MAX_VALUE, (String)"Wrong parameter value");
        Assert.assertEquals((int)constraintAnnotation.intParam(), (int)Integer.MAX_VALUE, (String)"Wrong parameter value");
        Assert.assertEquals((long)constraintAnnotation.longParam(), (long)Long.MAX_VALUE, (String)"Wrong parameter value");
        Assert.assertEquals((float)constraintAnnotation.floatParam(), (float)Float.MAX_VALUE, (String)"Wrong parameter value");
        Assert.assertEquals((double)constraintAnnotation.doubleParam(), (double)Double.MAX_VALUE, (String)"Wrong parameter value");
        Assert.assertEquals((boolean)constraintAnnotation.booleanParam(), (boolean)true, (String)"Wrong parameter value");
        Assert.assertEquals((char)constraintAnnotation.charParam(), (char)'A', (String)"Wrong parameter value");
        Assert.assertEquals((String)constraintAnnotation.stringParam(), (String)"foobar", (String)"Wrong parameter value");
        Assert.assertEquals(constraintAnnotation.classParam(), String.class, (String)"Wrong parameter value");
        Assert.assertEquals(constraintAnnotation.unqualifiedClassParam(), UserType.class, (String)"Wrong parameter value");
        Assert.assertEquals((Object)((Object)constraintAnnotation.userType()), (Object)((Object)UserType.SELLER), (String)"Wrong parameter value");
        Assert.assertEquals((Object[])constraintAnnotation.stringArrayParam(), (Object[])new String[]{"foo", "bar"}, (String)"Wrong parameter value");
        Assert.assertEquals((long)constraintAnnotation.max().value(), (long)10L, (String)"Wrong parameter value. Default should be used");
        Assert.assertEquals((int)constraintAnnotation.patterns().length, (int)2, (String)"Wrong array size");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-typeconversion", id="l")
    public void testIllegalAnnotationValueInXmlMappingCausesException() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(this.getStream("superuser-constraints.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        validator.getConstraintsForClass(SuperUser.class);
    }

    private InputStream getStream(String fileName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
    }
}

