/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.declaration;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Cinema;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Reference;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ValueExtractorFromServiceLoaderTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractorFromServiceLoaderTest.webArchiveBuilder().withTestClass(ValueExtractorFromServiceLoaderTest.class)).withPackage(Cinema.class.getPackage())).withResource("jakarta.validation.valueextraction.ValueExtractor", "META-INF/services/jakarta.validation.valueextraction.ValueExtractor", true)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="a")
    public void canDeclareValueExtractorViaServiceLoader() {
        Cinema cinema = Cinema.invalidReference();
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set violations = validator.validate((Object)cinema, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("visitor").containerElement("0", false, null, null, Reference.class, 0));
    }
}

