/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Payload;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.Actor;
import org.hibernate.beanvalidation.tck.tests.validation.ActorArrayBased;
import org.hibernate.beanvalidation.tck.tests.validation.ActorListBased;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.beanvalidation.tck.tests.validation.Boy;
import org.hibernate.beanvalidation.tck.tests.validation.ContainerElementsOrder;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Engine;
import org.hibernate.beanvalidation.tck.tests.validation.Item;
import org.hibernate.beanvalidation.tck.tests.validation.Last;
import org.hibernate.beanvalidation.tck.tests.validation.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.OrderLine;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.tests.validation.PlayedWith;
import org.hibernate.beanvalidation.tck.tests.validation.ProductCategory;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ValidateTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValidateTest.webArchiveBuilder().withTestClass(ValidateTest.class)).withClasses(Engine.class, Boy.class, Actor.class, ActorArrayBased.class, ActorListBased.class, PlayedWith.class, Customer.class, Person.class, Order.class, Address.class, BadlyBehavedEntity.class, Last.class, NotEmpty.class, ContainerElementsOrder.class, OrderLine.class, ProductCategory.class, Item.class)).build();
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="l"), @SpecAssertion(section="constraintmetadata-validator", id="c")})
    public void testUnexpectedTypeException() {
        Boy boy = new Boy();
        TestUtil.getValidatorUnderTest().validate((Object)boy, new Class[0]);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-validator", id="a")
    public void testConstraintDescriptorWithoutExplicitGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Set descriptors = propertyDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should be only one constraint descriptor");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0, (String)"There should be only one group");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The declared constraint does not explicitly define a group, hence Default is expected");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="constraintmetadata-validator", id="b")
    public void testNullParameterToGetConstraintsForClass() {
        TestUtil.getValidatorUnderTest().getConstraintsForClass(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="b")
    public void testValidateWithNullValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate(null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="b")
    public void testValidateWithNullGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Boy(), new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-validationmethods", id="a"), @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="c")})
    public void testMultipleViolationOfTheSameType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("mail@foobar.com");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class), ConstraintViolationAssert.violationOf(Pattern.class));
        engine.setSerialNumber("ABCDEFGH1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class));
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="c"), @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="c")})
    public void testMultipleConstraintViolationOfDifferentTypes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        address.setCity("Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch");
        Set constraintViolations = validator.validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class), ConstraintViolationAssert.violationOf(NotEmpty.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="a"), @SpecAssertion(section="validationapi-constraintviolation", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="i"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="l"), @SpecAssertion(section="constraintmetadata-constraintdescriptor", id="a")})
    public void testConstraintViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class));
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)violation.getMessage(), (String)"must match ^....-....-....$", (String)"Wrong message");
        Assert.assertEquals((String)violation.getMessageTemplate(), (String)"must match {regexp}", (String)"Wrong message template");
        Assert.assertEquals((Object)violation.getRootBean(), (Object)engine, (String)"Wrong root entity.");
        Assert.assertEquals((Object)violation.getRootBeanClass(), Engine.class, (String)"Wrong root bean class.");
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)engine);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"ABCDEFGH1234", (String)"Wrong validated value");
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertNull((Object)violation.getExecutableReturnValue());
        Assert.assertNotNull((Object)violation.getConstraintDescriptor(), (String)"Constraint descriptor should not be null");
        Annotation ann = violation.getConstraintDescriptor().getAnnotation();
        Assert.assertEquals(ann.annotationType(), Pattern.class, (String)"Wrong annotation type");
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("serialNumber"));
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="validationapi-constraintviolation", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testClassLevelConstraintViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DirtBike bike = new DirtBike();
        Set constraintViolations = validator.validate((Object)bike, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidDirtBike.class));
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)bike, (String)"Wrong root entity.");
        Assert.assertEquals((Object)violation.getRootBeanClass(), DirtBike.class, (String)"Wrong root bean class.");
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)bike, (String)"Wrong leaf bean.");
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)bike, (String)"Wrong validated value");
        Assert.assertNotNull((Object)violation.getConstraintDescriptor(), (String)"Constraint descriptor should not be null");
        Annotation ann = violation.getConstraintDescriptor().getAnnotation();
        Assert.assertEquals(ann.annotationType(), ValidDirtBike.class, (String)"Wrong annotation type");
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().bean());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="s"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="validationapi-constraintviolation", id="f")})
    public void testGraphValidationWithList() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Everyone has a last name.").withPropertyPath(ConstraintViolationAssert.pathWith().property("playedWith").property("playedWith", true, null, 0, List.class, 0).property("lastName", true, null, 1, List.class, 0)), ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Everyone has a last name.").withPropertyPath(ConstraintViolationAssert.pathWith().property("playedWith").property("lastName", true, null, 1, List.class, 0)));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getLeafBean(), (Object)morgan);
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="s"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="d")})
    public void testGraphValidationWithArray() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Everyone has a last name.").withPropertyPath(ConstraintViolationAssert.pathWith().property("playedWith").property("playedWith", true, null, 0, Object[].class, null).property("lastName", true, null, 1, Object[].class, null)), ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Everyone has a last name.").withPropertyPath(ConstraintViolationAssert.pathWith().property("playedWith").property("lastName", true, null, 1, Object[].class, null)));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="b")
    public void testOnlyFirstGroupInSequenceGetEvaluated() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Car car = new Car("USd-298");
        Set violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class));
        car.setLicensePlateNumber("USD-298");
        violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="k")
    public void testUnexpectedExceptionsInValidateGetWrappedInValidationExceptions() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new BadlyBehavedEntity(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="validationapi-constraintviolation", id="f")
    public void testContainerElementLeafBean() throws NoSuchMethodException, SecurityException {
        Item invalidItem = new Item("s");
        HashMap<ProductCategory, List<OrderLine>> invalidOrderLines = new HashMap<ProductCategory, List<OrderLine>>();
        invalidOrderLines.put(null, Arrays.asList(new OrderLine(new Item("item name"))));
        invalidOrderLines.put(ProductCategory.MUSIC, Arrays.asList(new OrderLine(invalidItem)));
        ContainerElementsOrder invalidOrder = new ContainerElementsOrder("order name", invalidOrderLines);
        Set violations = this.getValidator().validate((Object)invalidOrder, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean(invalidOrder), ConstraintViolationAssert.violationOf(Size.class).withLeafBean(invalidItem));
    }

    @ValidDirtBike
    private static class DirtBike {
        private DirtBike() {
        }
    }

    @Constraint(validatedBy={Validator.class})
    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidDirtBike {
        public String message() default "{ValidDirtBike.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ValidDirtBike, DirtBike> {
            public boolean isValid(DirtBike bike, ConstraintValidatorContext constraintValidatorContext) {
                return false;
            }
        }
    }

    private static class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class}) String licensePlateNumber;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }

        public void setLicensePlateNumber(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }
    }

    private static interface First {
    }

    private static interface Second {
    }
}

