/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import jakarta.validation.Validation;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidStockItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidStockItemRecord;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.StockItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.StockItemRecord;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.webArchiveBuilder().withTestClass(ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.class)).withClass(StockItem.class)).withClass(ValidStockItem.class)).withClass(StockItemRecord.class)).withClass(ValidStockItemRecord.class)).withValidationXml("validation-ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(StockItem.class).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        StockItem createdObject = new StockItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidStockItem.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(StockItem.class).returnValue()));
    }

    @Test
    public void testValidateRecordConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItemRecord.class.getConstructor(String.class);
        StockItemRecord createdObject = new StockItemRecord(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidStockItemRecord.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(StockItemRecord.class).returnValue()));
    }
}

