/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.application.method;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.Account;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.CalendarEvent;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.CalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.ConsistentDateParameters;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.OnlineCalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class MethodValidationRequirementTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)MethodValidationRequirementTest.webArchiveBuilder().withTestClassPackage(MethodValidationRequirementTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints", id="a")
    public void testMethodParameterConstraintsAreDeclaredByAnnotatingParameters() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("setType", String.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints", id="a")
    public void testConstructorParameterConstraintsAreDeclaredByAnnotatingParameters() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(String.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-crossparameterconstraints", id="a")
    public void testCrossParameterConstraintsAreDeclaredByAnnotatingMethods() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[]{new Date(), new Date(new Date().getTime() - 1000L)};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ConsistentDateParameters.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-crossparameterconstraints", id="a")
    public void testCrossParameterConstraintsAreDeclaredByAnnotatingConstructors() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(Date.class, Date.class);
        Object[] parameterValues = new Object[]{new Date(), new Date(new Date().getTime() - 1000L)};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ConsistentDateParameters.class));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="a")
    public void testMethodParameterAndCrossParameterConstraintsAreEvaluatedAtTheSameTime() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class, Integer.class);
        Object[] parameterValues = new Object[3];
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class), ConstraintViolationAssert.violationOf(ConsistentDateParameters.class));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="g")
    public void testConstructorParameterAndCrossParameterConstraintsAreEvaluatedAtTheSameTime() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(Date.class, Date.class, Integer.class);
        Object[] parameterValues = new Object[3];
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class), ConstraintViolationAssert.violationOf(ConsistentDateParameters.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-returnvalueconstraints", id="a")
    public void testReturnValueConstraintsAreDeclaredByAnnotatingMethods() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("findEvents", String.class);
        Object returnValue = null;
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-returnvalueconstraints", id="a")
    public void testReturnValueConstraintsAreDeclaredByAnnotatingConstructors() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(new Class[0]);
        CalendarService returnValue = new CalendarService();
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(OnlineCalendarService.class));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="a")
    public void testMethodParameterIsMarkedAsCascaded() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[]{new User()};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setUser").parameter("user", 0).property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="a")
    public void testConstructorParameterIsMarkedAsCascaded() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[]{new User()};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(CalendarEvent.class).parameter("user", 0).property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="a")
    public void testMethodReturnValueIsMarkedAsCascaded() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        User returnValue = new User();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("getUser").returnValue().property("name")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="a")
    public void testConstructorReturnValueIsMarkedAsCascaded() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(String.class);
        CalendarEvent returnValue = new CalendarEvent(null, null);
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(CalendarEvent.class).returnValue().property("type")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="b")
    public void testPassingNullToCascadedMethodParameterCausesNoViolation() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="b")
    public void testPassingNullToCascadedConstructorParameterCausesNoViolation() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="b")
    public void testReturningNullFromCascadedMethodCausesNoViolation() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        Object returnValue = null;
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="c")
    public void testCascadedMethodParameterIsValidatedRecursively() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[]{new User(new Account())};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setUser").parameter("user", 0).property("account").property("login")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="c")
    public void testCascadedConstructorParameterIsValidatedRecursively() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[]{new User(new Account())};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(CalendarEvent.class).parameter("user", 0).property("account").property("login")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="c")
    public void testCascadedMethodReturnValueIsValidatedRecursively() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        User returnValue = new User(new Account());
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("getUser").returnValue().property("account").property("login")));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-cascadedvalidation", id="c")
    public void testCascadedConstructorReturnValueIsValidatedRecursively() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(String.class);
        CalendarEvent returnValue = new CalendarEvent();
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(CalendarEvent.class).returnValue().property("user").property("name")));
    }
}

