/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.edapt.common.ui.IValueValidator;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.common.ui.ValueSelectionComposite;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class MultiValueSelectionDialog
extends SelectionStatusDialog {
    protected final AdapterFactoryLabelProvider labelProvider;
    private final Collection valueArea;
    private final List values;
    private ValueSelectionComposite composite;
    private final IValueValidator validator;
    private TableViewer valuesViewer;

    public MultiValueSelectionDialog(Shell parent, Image image, String title, List values, Collection valueArea, AdapterFactoryLabelProvider labelProvider, IValueValidator validator) {
        super(parent);
        this.setImage(image);
        this.setTitle(title);
        this.values = new ArrayList(values);
        this.valueArea = valueArea;
        this.labelProvider = labelProvider;
        this.validator = validator;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setSize(650, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)contents.getLayout();
        layout.numColumns = 3;
        this.createValueSelectionComposite(contents);
        this.createButtons(contents);
        this.createValueList(contents);
        return contents;
    }

    private void createValueSelectionComposite(Composite contents) {
        this.composite = new ValueSelectionComposite(contents, this.labelProvider, this.values, true, this.valueArea, this.validator);
        this.composite.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (MultiValueSelectionDialog.this.composite.validSelection()) {
                    MultiValueSelectionDialog.this.addSelectedValues();
                }
            }
        });
    }

    private void createValueList(Composite contents) {
        this.valuesViewer = new TableViewer(contents);
        GridData data = new GridData(1040);
        data.widthHint = 200;
        this.valuesViewer.getTable().setLayoutData((Object)data);
        this.valuesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.valuesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.valuesViewer.setInput((Object)this.values);
        this.valuesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MultiValueSelectionDialog.this.removeSelectedValues();
            }
        });
    }

    private void createButtons(Composite contents) {
        Composite buttonComposite = new Composite(contents, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(1040);
        data.widthHint = 50;
        buttonComposite.setLayoutData((Object)data);
        Button addButton = new Button(buttonComposite, 0);
        addButton.setText("add");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValueSelectionDialog.this.addSelectedValues();
            }
        });
        Button removeButton = new Button(buttonComposite, 0);
        removeButton.setText("remove");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValueSelectionDialog.this.removeSelectedValues();
            }
        });
        new Label(buttonComposite, 0);
        Button upButton = new Button(buttonComposite, 0);
        upButton.setText("up");
        upButton.setLayoutData((Object)new GridData(768));
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValueSelectionDialog.this.upSelectedValues();
            }
        });
        Button downButton = new Button(buttonComposite, 0);
        downButton.setText("down");
        downButton.setLayoutData((Object)new GridData(768));
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValueSelectionDialog.this.downSelectedValues();
            }
        });
        new Label(buttonComposite, 0);
        Button clearButton = new Button(buttonComposite, 0);
        clearButton.setText("clear");
        clearButton.setLayoutData((Object)new GridData(768));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValueSelectionDialog.this.clearSelectedValues();
            }
        });
    }

    protected void clearSelectedValues() {
        this.values.clear();
        this.valuesViewer.refresh();
    }

    protected void downSelectedValues() {
        List<Object> selectedValues = SelectionUtils.getSelectedElements(this.valuesViewer.getSelection());
        this.sortSelectedValues(selectedValues);
        Collections.reverse(selectedValues);
        for (Object element : selectedValues) {
            int index = this.values.indexOf(element);
            if (index >= this.values.size() - 1 || selectedValues.contains(this.values.get(index + 1))) continue;
            this.values.remove(element);
            this.values.add(index + 1, element);
        }
        this.valuesViewer.refresh();
    }

    protected void upSelectedValues() {
        List<Object> selectedValues = SelectionUtils.getSelectedElements(this.valuesViewer.getSelection());
        this.sortSelectedValues(selectedValues);
        for (Object element : selectedValues) {
            int index = this.values.indexOf(element);
            if (index <= 0 || selectedValues.contains(this.values.get(index - 1))) continue;
            this.values.remove(element);
            this.values.add(index - 1, element);
        }
        this.valuesViewer.refresh();
    }

    private void sortSelectedValues(List<Object> selectedValues) {
        Collections.sort(selectedValues, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return MultiValueSelectionDialog.this.values.indexOf(o1) - MultiValueSelectionDialog.this.values.indexOf(o2);
            }
        });
    }

    protected void removeSelectedValues() {
        List selectedValues = SelectionUtils.getSelectedElements(this.valuesViewer.getSelection());
        this.values.removeAll(selectedValues);
        this.valuesViewer.refresh();
    }

    protected void addSelectedValues() {
        List<Object> selectedValues = this.composite.getSelectedElements();
        for (Object element : selectedValues) {
            if (this.values.contains(element)) continue;
            this.values.add(element);
        }
        this.valuesViewer.refresh();
    }

    protected void computeResult() {
        this.setResult(this.values);
    }
}

