/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.BidirectionalMap;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.ConditionServiceManager;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;

public class RuleRegistry<T extends Rule> {
    private final Map<UniqueSetting, BidirectionalMap<Condition, T>> settingToRules;
    private final BidirectionalMap<T, VElement> rulesToRenderables;
    private final Map<Condition, Set<UniqueSetting>> conditionToSettings;
    private final ViewModelContext context;
    private final Map<VDomainModelReference, Set<T>> dmrsToRules;
    private final DomainModelChangeListener domainModelChangeListener;
    private final ConditionServiceManager conditionServiceManager;

    public RuleRegistry(ViewModelContext context) {
        this.context = context;
        this.settingToRules = new LinkedHashMap<UniqueSetting, BidirectionalMap<Condition, T>>();
        this.rulesToRenderables = new BidirectionalMap();
        this.conditionToSettings = new LinkedHashMap<Condition, Set<UniqueSetting>>();
        this.dmrsToRules = new WeakHashMap<VDomainModelReference, Set<T>>();
        this.domainModelChangeListener = new DomainModelChangeListener();
        context.registerDomainChangeListener((ModelChangeListener)this.domainModelChangeListener);
        this.conditionServiceManager = (ConditionServiceManager)context.getService(ConditionServiceManager.class);
    }

    public Set<UniqueSetting> register(VElement renderable, T rule, Condition condition, EObject domainModel) {
        this.rulesToRenderables.put(rule, (Object)renderable);
        Set<UniqueSetting> settings = this.conditionServiceManager.getConditionSettings(condition, domainModel);
        for (UniqueSetting setting : settings) {
            this.mapSettingToRule(setting, condition, rule);
        }
        Set<VDomainModelReference> domainModelReferences = this.conditionServiceManager.getDomainModelReferences(condition);
        this.mapDomainToDMRs(rule, domainModelReferences);
        return settings;
    }

    public VElement removeRule(T rule) {
        this.removeDomainModelChangeListener(rule);
        Condition condition = rule.getCondition();
        if (condition != null) {
            return this.removeCondition(condition);
        }
        Collection<BidirectionalMap<Condition, T>> values = this.settingToRules.values();
        for (BidirectionalMap<Condition, T> bidirectionalMap : values) {
            if (bidirectionalMap.removeByValue(rule) != null) break;
        }
        VElement renderable = (VElement)this.rulesToRenderables.getValue(rule);
        this.rulesToRenderables.removeByKey(rule);
        return renderable;
    }

    private void removeDomainModelChangeListener(T rule) {
        LinkedHashSet<VDomainModelReference> dmrs = new LinkedHashSet<VDomainModelReference>(this.dmrsToRules.keySet());
        for (VDomainModelReference dmr : dmrs) {
            Set<T> rules = this.dmrsToRules.get(dmr);
            if (rules == null) continue;
            rules.remove(rule);
        }
    }

    public void removeRenderable(VElement renderable) {
        Rule rule = (Rule)this.rulesToRenderables.removeByValue((Object)renderable);
        this.removeDomainModelChangeListener(rule);
    }

    public VElement removeCondition(Condition condition) {
        VElement ret = null;
        Rule rule = null;
        Set<UniqueSetting> settings = this.conditionToSettings.remove(condition);
        if (settings == null) {
            return ret;
        }
        for (UniqueSetting setting : settings) {
            BidirectionalMap<Condition, T> rules = this.settingToRules.get(setting);
            if (rules.keys().contains(condition)) {
                rule = (Rule)rules.removeByKey((Object)condition);
            }
            if (!rules.keys().isEmpty()) continue;
            this.settingToRules.remove(setting);
        }
        if (rule != null) {
            this.removeDomainModelChangeListener(rule);
            ret = (VElement)this.rulesToRenderables.removeByKey(rule);
        }
        return ret;
    }

    private void mapSettingToRule(UniqueSetting uniqueSetting, Condition condition, T rule) {
        if (!this.settingToRules.containsKey(uniqueSetting)) {
            this.settingToRules.put(uniqueSetting, new BidirectionalMap());
        }
        this.settingToRules.get(uniqueSetting).put((Object)condition, rule);
        if (!this.conditionToSettings.containsKey(condition)) {
            this.conditionToSettings.put(condition, new LinkedHashSet());
        }
        this.conditionToSettings.get(condition).add(uniqueSetting);
    }

    public Set<UniqueSetting> getSettings() {
        return this.settingToRules.keySet();
    }

    public Map<T, VElement> getAffectedRenderables(UniqueSetting setting) {
        LinkedHashMap<Rule, VElement> result = new LinkedHashMap<Rule, VElement>();
        BidirectionalMap<Condition, T> bidirectionalMap = this.settingToRules.get(setting);
        if (bidirectionalMap == null) {
            return Collections.emptyMap();
        }
        for (Rule rule : bidirectionalMap.values()) {
            VElement renderable = (VElement)this.rulesToRenderables.getValue((Object)rule);
            result.put(rule, renderable);
        }
        return result;
    }

    private void mapDomainToDMRs(T rule, Set<VDomainModelReference> references) {
        for (VDomainModelReference reference : references) {
            if (!this.dmrsToRules.containsKey(reference)) {
                this.dmrsToRules.put(reference, new LinkedHashSet());
            }
            this.dmrsToRules.get(reference).add(rule);
        }
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener((ModelChangeListener)this.domainModelChangeListener);
    }

    private class DomainModelChangeListener
    implements ModelChangeListener {
        private final EMFFormsStructuralChangeTester structuralChangeTester;

        DomainModelChangeListener() {
            this.structuralChangeTester = (EMFFormsStructuralChangeTester)RuleRegistry.this.context.getService(EMFFormsStructuralChangeTester.class);
        }

        public void notifyChange(ModelChangeNotification notification) {
            LinkedHashSet dmrs = new LinkedHashSet(RuleRegistry.this.dmrsToRules.keySet());
            for (VDomainModelReference dmr : dmrs) {
                if (!this.structuralChangeTester.isStructureChanged(dmr, RuleRegistry.this.context.getDomainModel(), notification)) continue;
                Set rules = (Set)RuleRegistry.this.dmrsToRules.remove(dmr);
                if (rules == null) {
                    return;
                }
                for (Rule rule : rules) {
                    VElement element = RuleRegistry.this.removeRule(rule);
                    if (element == null) {
                        return;
                    }
                    RuleRegistry.this.register(element, rule, rule.getCondition(), RuleRegistry.this.context.getDomainModel());
                }
            }
        }
    }
}

