/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.flow.FlowsActivator;
import org.eclipse.dirigible.runtime.listener.IListenerEventProcessor;
import org.eclipse.dirigible.runtime.listener.IListenerEventProcessorProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ListenerEventProcessorFactory {
    private static final Logger logger = Logger.getLogger(ListenerEventProcessorFactory.class);
    private static final List<IListenerEventProcessorProvider> listenerEventProcessorProviders = Collections.synchronizedList(new ArrayList());
    private static boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListenerEventProcessorProviders(BundleContext context) throws InvalidSyntaxException {
        logger.info("Registering Listener Event Processor Providers...");
        Class<ListenerEventProcessorFactory> clazz = ListenerEventProcessorFactory.class;
        synchronized (ListenerEventProcessorFactory.class) {
            Collection serviceReferences = context.getServiceReferences(IListenerEventProcessorProvider.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                IListenerEventProcessorProvider listenerEventProcessorProvider = (IListenerEventProcessorProvider)context.getService(serviceReference);
                listenerEventProcessorProviders.add(listenerEventProcessorProvider);
                logger.info(String.format("%s added to the list of available Listener Event Processor Providers", listenerEventProcessorProvider.getClass().getCanonicalName()));
            }
            registered = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static IListenerEventProcessor createListenerEventProcessor(String trigger) {
        if (!registered) {
            try {
                ListenerEventProcessorFactory.registerListenerEventProcessorProviders(FlowsActivator.getContext());
            }
            catch (InvalidSyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (IListenerEventProcessorProvider listenerEventProcessorProvider : listenerEventProcessorProviders) {
            if (!listenerEventProcessorProvider.getTriggerType().equals(trigger)) continue;
            return listenerEventProcessorProvider.createListenerEventProcessor();
        }
        return null;
    }
}

