/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.gmf.GMFDiffPolicy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.sequence.ordering.OrderingPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SiriusDiffPolicy
extends GMFDiffPolicy {
    private static final char SEGMENT_SEPARATOR = '/';
    private static final Collection<EReference> SEMANTICALLY_UNORDERED_REFERENCES = Arrays.asList(DiagramPackage.eINSTANCE.getDDiagram_ActivatedLayers(), DiagramPackage.eINSTANCE.getDDiagram_OwnedDiagramElements(), ViewpointPackage.eINSTANCE.getDAnalysis_Models(), ViewpointPackage.eINSTANCE.getDAnalysis_OwnedViews(), ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements(), DiagramPackage.eINSTANCE.getEdgeTarget_IncomingEdges(), DiagramPackage.eINSTANCE.getEdgeTarget_OutgoingEdges());
    private static final Collection<EReference> UNSIGNIFICANT_REFERENCES = Arrays.asList(ViewpointPackage.eINSTANCE.getDRepresentation_UiState(), DiagramPackage.eINSTANCE.getDDiagram_HiddenElements());
    private static final Collection<EClass> UNSIGNIFICANT_TYPES = Arrays.asList(OrderingPackage.eINSTANCE.getEventEndsOrdering(), OrderingPackage.eINSTANCE.getInstanceRolesOrdering(), ViewpointPackage.eINSTANCE.getUIState());
    private static final Collection<EAttribute> IGNORING_EMPTY_STRING_ATTRIBUTES = Arrays.asList(DiagramPackage.eINSTANCE.getDDiagramElement_TooltipText());

    public boolean considerEqual(Object value1_p, Object value2_p, EAttribute attribute_p) {
        boolean result = super.considerEqual(value1_p, value2_p, attribute_p);
        if (!result && ViewpointPackage.eINSTANCE.getDAnalysis_SemanticResources() == attribute_p) {
            URI refURI = ((ResourceDescriptor)value1_p).getResourceURI();
            URI trgtURI = ((ResourceDescriptor)value2_p).getResourceURI();
            int positionInRefURI = this.getProjectPositionInURI(refURI);
            int positionInTrgtURI = this.getProjectPositionInURI(trgtURI);
            String refURIStr = positionInRefURI != -1 ? this.makeRelativeToProject(refURI, positionInRefURI) : refURI.toString();
            String trgtURIStr = positionInTrgtURI != -1 ? this.makeRelativeToProject(trgtURI, positionInTrgtURI) : trgtURI.toString();
            return refURIStr.equals(trgtURIStr);
        }
        return result;
    }

    public boolean coverFeature(EStructuralFeature feature_p) {
        return !UNSIGNIFICANT_REFERENCES.contains(feature_p) && super.coverFeature(feature_p);
    }

    public boolean coverMatch(IMatch match_p) {
        EObject element;
        boolean result = super.coverMatch(match_p);
        if (result && match_p.isPartial() && (element = match_p.get(match_p.getUncoveredRole().opposite())) != null) {
            result = !UNSIGNIFICANT_TYPES.contains(element.eClass());
        }
        return result;
    }

    public boolean coverValue(Object value_p, EAttribute attribute_p) {
        boolean result = IGNORING_EMPTY_STRING_ATTRIBUTES.contains(attribute_p) && ((String)value_p).length() == 0 ? false : super.coverValue(value_p, attribute_p);
        return result;
    }

    protected boolean doConsiderOrdered(EStructuralFeature feature_p) {
        return super.doConsiderOrdered(feature_p) && !SEMANTICALLY_UNORDERED_REFERENCES.contains(feature_p);
    }

    protected int getProjectPositionInURI(URI uri_p) {
        if (uri_p.isPlatformResource()) {
            return 2;
        }
        return -1;
    }

    protected String makeRelativeToProject(URI uri_p, int projectPositionInURI_p) {
        StringBuilder result = new StringBuilder();
        int i = projectPositionInURI_p;
        while (i < uri_p.segments().length) {
            result.append('/');
            result.append(uri_p.segment(i));
            ++i;
        }
        return result.toString();
    }
}

