/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnetexport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.acute.SWTBotTests.dotnetexport.AbstractExportWizardTest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdatingDefault
extends AbstractExportWizardTest {
    private IFile projectCSFile;

    @Override
    public void setup() throws CoreException {
        this.buildEmptyProject();
        IFile codeFile = this.project.getFile("Project.cs");
        codeFile.create(this.getClass().getResourceAsStream(codeFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        this.projectCSFile = this.project.getFile("multipleFrameworks.csproj");
        this.projectCSFile.create(this.getClass().getResourceAsStream(this.projectCSFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        this.openExportWizard();
    }

    @Test
    public void TestDefaultExportLocation() {
        String frameworkString = "netcoreapp1.0";
        String expectedExportSubDirectory = "/bin/Release/netcoreapp1.0/" + this.getDefaultRuntime() + "/";
        bot.list().select("netcoreapp1.0");
        bot.checkBox("Self-Contained Deployment").click();
        bot.radio("Release").click();
        SWTBotText exportLocation = bot.textWithLabel("Location:", 2);
        Assert.assertTrue((String)("Export location: " + exportLocation.getText() + " does not match: .*" + expectedExportSubDirectory + " after field changes."), (boolean)exportLocation.getText().matches(".*" + expectedExportSubDirectory));
    }

    @Override
    public void tearDown() throws CoreException {
        bot.button("Cancel").click();
        super.tearDown();
    }

    private String getDefaultRuntime() {
        String listCommand = "dotnet --info";
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(listCommand);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.matches("^\\sRID:\\s+.*$")) continue;
                    return inputLine.replaceFirst("^\\sRID:\\s+", "").replaceAll("\\s", "");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "";
        }
        return "";
    }
}

