/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.commands.NewAppCommand;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.New4diacProjectPage;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class New4diacProjectWizard
extends Wizard
implements INewWizard {
    private New4diacProjectPage page;

    public New4diacProjectWizard() {
        this.setWindowTitle(Messages.New4diacProjectWizard_WizardName);
    }

    public void addPages() {
        this.page = new New4diacProjectPage(Messages.New4diacProjectWizard_WizardName);
        this.page.setTitle(Messages.New4diacProjectWizard_WizardName);
        this.page.setDescription(Messages.New4diacProjectWizard_WizardDesc);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    New4diacProjectWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private void createProject(IProgressMonitor monitor) {
        try {
            try {
                IProject newProject = SystemManager.INSTANCE.createNew4diacProject(this.page.getProjectName(), this.page.getLocationPath(), this.page.importDefaultPalette(), monitor);
                AutomationSystem system = SystemManager.INSTANCE.createNewSystem((IContainer)newProject, this.page.getInitialSystemName());
                TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)system);
                this.createInitialApplication(monitor, system);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createInitialApplication(IProgressMonitor monitor, AutomationSystem system) {
        NewAppCommand cmd = new NewAppCommand(system, this.page.getInitialApplicationName(), "");
        cmd.execute(monitor, null);
        Application app = cmd.getApplication();
        if (this.page.getOpenApplication() && app != null) {
            OpenListenerManager.openEditor((EObject)app);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

