/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class InitialNameGroup
extends Composite {
    private Text name;
    private boolean nameManuallyChanged = false;
    private boolean blockListeners = false;
    private Listener applicationNameModifyListener = e -> {
        if (!this.blockListeners) {
            this.nameManuallyChanged = true;
        }
    };

    public InitialNameGroup(Composite parent, String labelText) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        Label applicationLabel = new Label((Composite)this, 0);
        applicationLabel.setText(labelText);
        applicationLabel.setFont(parent.getFont());
        this.name = new Text((Composite)this, 2048);
        GridData data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.setFont(parent.getFont());
        this.name.addListener(24, this.applicationNameModifyListener);
    }

    public String getInitialName() {
        return this.name.getText();
    }

    public boolean validateName(String projectName) {
        if (!this.nameManuallyChanged) {
            this.blockListeners = true;
            this.name.setText(projectName);
            this.blockListeners = false;
        } else if (!IdentifierVerifyer.isValidIdentifier((String)this.getInitialName())) {
            return false;
        }
        return true;
    }

    public void addNameModifyListener(Listener nameModifyListener) {
        this.name.addListener(24, nameModifyListener);
    }
}

