/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.FordiacProjectSorter;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class SystemLabelProvider
extends AdapterFactoryLabelProvider
implements IDescriptionProvider {
    private static ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemLabelProvider.createFactoryList());

    public SystemLabelProvider() {
        super((AdapterFactory)systemAdapterFactory);
    }

    public String getText(Object object) {
        if (object instanceof IFile) {
            return SystemLabelProvider.getTextForFiles((IFile)object);
        }
        if (object instanceof IResource) {
            return null;
        }
        return super.getText(object);
    }

    private static String getTextForFiles(IFile element) {
        String text = null;
        if ("DTP".equalsIgnoreCase(element.getFileExtension()) || "DEV".equalsIgnoreCase(element.getFileExtension()) || "RES".equalsIgnoreCase(element.getFileExtension()) || "SEG".equalsIgnoreCase(element.getFileExtension()) || "SYS".equalsIgnoreCase(element.getFileExtension())) {
            text = TypeLibrary.getTypeNameFromFile((IFile)element);
        }
        return text;
    }

    public Image getImage(Object object) {
        if (object instanceof IResource) {
            return SystemLabelProvider.getImageForResource((IResource)object);
        }
        return super.getImage(object);
    }

    private static Image getImageForResource(IResource resource) {
        if (FordiacProjectSorter.isTypeLibFolder(resource)) {
            return FordiacImage.ICON_TYPE_NAVIGATOR.getImage();
        }
        return null;
    }

    public String getDescription(Object anElement) {
        return super.getText(anElement);
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        factories.add((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }
}

