/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditor;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditorInput;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeAndSubAppInstanceViewerInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeInstanceViewer;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.DiagramOutlinePage;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.listeners.EditorTabCommandStackListener;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.subapptypeeditor.viewer.SubappInstanceViewer;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditor;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditorInput;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.IEditorFileChangeListener;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.editors.SystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.AutomationSystemProviderAdapterFactory;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.SystemLabelProvider;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AutomationSystemEditor
extends AbstractBreadCrumbEditor
implements IEditorFileChangeListener {
    private AutomationSystem system;
    private DiagramOutlinePage outlinePage;
    private final EditorTabCommandStackListener subEditorCommandStackListener = new EditorTabCommandStackListener((INavigationLocationProvider)this);

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.loadSystem();
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void addPages() {
        try {
            int pagenum = this.addPage((IEditorPart)new SystemEditor(), this.getEditorInput());
            this.getModelToEditorNumMapping().put(this.system, pagenum);
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void loadSystem() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            this.system = SystemManager.INSTANCE.getSystem(((FileEditorInput)this.getEditorInput()).getFile());
            if (this.system != null) {
                this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
                this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this.subEditorCommandStackListener);
                this.setPartName(this.system.getName());
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (-1 != newPageIndex && this.outlinePage != null) {
            GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
            this.outlinePage.viewerChanged(viewer);
        }
    }

    protected EditorPart createEditorPart(Object model) {
        if (model instanceof IFile) {
            return new SystemEditor();
        }
        if (model instanceof CFBInstance) {
            return new CompositeInstanceViewer();
        }
        if (model instanceof SubApp) {
            if (((SubApp)model).isTyped() || ((SubApp)model).isContainedInTypedInstance()) {
                return new SubappInstanceViewer();
            }
            return new SubAppNetworkEditor();
        }
        if (model instanceof Application) {
            return new ApplicationEditor();
        }
        if (model instanceof SystemConfiguration) {
            return new SystemConfigurationEditor();
        }
        if (model instanceof Device) {
            return new SystemConfigurationEditor();
        }
        if (model instanceof Resource) {
            return new ResourceDiagramEditor();
        }
        return null;
    }

    protected IEditorInput createEditorInput(Object model) {
        if (model instanceof IFile) {
            return this.getEditorInput();
        }
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped() || subApp.isContainedInTypedInstance()) {
                return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)subApp);
            }
            return new SubApplicationEditorInput(subApp);
        }
        if (model instanceof CFBInstance) {
            return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)((FB)model));
        }
        if (model instanceof Application) {
            return new ApplicationEditorInput((Application)model);
        }
        if (model instanceof SystemConfiguration) {
            return new SystemConfigurationEditorInput((SystemConfiguration)model);
        }
        if (model instanceof Device) {
            return new SystemConfigurationEditorInput(((Device)model).getSystemConfiguration());
        }
        if (model instanceof Resource) {
            return new ResourceEditorInput((Resource)model);
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.system != null) {
            SystemManager.saveSystem((AutomationSystem)this.system);
            this.getCommandStack().markSaveLocation();
            this.firePropertyChange(257);
        }
    }

    protected AdapterFactoryContentProvider createBreadcrumbContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new AutomationSystemProviderAdapterFactory());
    }

    protected AdapterFactoryLabelProvider createBreadcrumbLabelProvider() {
        return new SystemLabelProvider();
    }

    protected Object getInitialModel(String itemPath) {
        EObject targetmodel;
        String[] nameList;
        if (itemPath != null && (nameList = itemPath.split("\\.")).length > 1 && (targetmodel = this.getTargetModel(Arrays.copyOfRange(nameList, 1, nameList.length))) != null) {
            return targetmodel;
        }
        return this.system;
    }

    public void doSaveAs() {
        if (this.system == null) {
            return;
        }
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalName(this.system.getSystemFile().getName());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path == null) {
            return;
        }
        IPath fullPath = this.system.getSystemFile().getFullPath();
        if (fullPath.equals((Object)path)) {
            this.doSave(null);
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        SystemManager.saveSystem((AutomationSystem)this.system, (IFile)file);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new DiagramOutlinePage((GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class));
            }
            return adapter.cast(this.outlinePage);
        }
        if (adapter == AutomationSystem.class) {
            return adapter.cast(this.system);
        }
        return (T)super.getAdapter(adapter);
    }

    public CommandStack getCommandStack() {
        return this.system != null ? this.system.getCommandStack() : null;
    }

    public String getContributorId() {
        return "org.eclipse.fordiac.ide.application.editors.DiagramEditor";
    }

    protected void gotoFBNetworkElement(Object object) {
        EObject targetmodel;
        String[] split = ((String)object).split("\\.");
        if (split.length >= 2 && (targetmodel = this.getTargetModel(Arrays.copyOf(split, split.length - 1))) != null) {
            this.getBreadcrumb().setInput((Object)targetmodel);
            FBNetworkEditor fbEditor = this.getAdapter(FBNetworkEditor.class);
            if (fbEditor != null) {
                FBNetworkElement elementToSelect = fbEditor.getModel().getElementNamed(split[split.length - 1]);
                fbEditor.selectElement((Object)elementToSelect);
            }
        }
    }

    private EObject getTargetModel(String[] path) {
        Application retVal = this.system.getApplicationNamed(path[0]);
        if (retVal != null) {
            if (path.length > 1) {
                retVal = AutomationSystemEditor.parseSubappPath(retVal.getFBNetwork(), Arrays.copyOfRange(path, 1, path.length));
            }
        } else if (path.length > 2 && (retVal = this.system.getDeviceNamed(path[0])) != null && (retVal = ((Device)retVal).getResourceNamed(path[1])) != null && path.length > 2) {
            retVal = AutomationSystemEditor.parseSubappPath(((Resource)retVal).getFBNetwork(), Arrays.copyOfRange(path, 2, path.length));
        }
        return retVal;
    }

    private static EObject parseSubappPath(FBNetwork network, String[] path) {
        FBNetworkElement retVal = null;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            retVal = network.getElementNamed(element);
            if (retVal instanceof SubApp) {
                network = AutomationSystemEditor.getSubAppNetwork((SubApp)retVal);
            } else if (retVal instanceof CFBInstance) {
                network = AutomationSystemEditor.getCFBNetwork((CFBInstance)retVal);
            } else {
                return null;
            }
            if (network == null) {
                return null;
            }
            ++n2;
        }
        return retVal;
    }

    private static FBNetwork getSubAppNetwork(SubApp subApp) {
        FBNetwork network = subApp.getSubAppNetwork();
        if (network == null) {
            network = subApp.loadSubAppNetwork();
        }
        return network;
    }

    private static FBNetwork getCFBNetwork(CFBInstance cfb) {
        FBNetwork network = cfb.getCfbNetwork();
        if (network == null) {
            network = cfb.loadCFBNetwork();
        }
        return network;
    }

    public IFile getFile() {
        return this.system.getSystemFile();
    }

    public void dispose() {
        if (this.getCommandStack() != null) {
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this.subEditorCommandStackListener);
        }
        super.dispose();
    }

    public void reloadFile() {
        CommandStack commandStack = this.system.getCommandStack();
        this.system = SystemManager.INSTANCE.replaceSystemFromFile(this.system, this.getFile());
        this.system.setCommandStack(commandStack);
        this.getCommandStack().flush();
        if (!this.system.getApplication().isEmpty()) {
            OpenListenerManager.openEditor((EObject)((EObject)this.system.getApplication().get(0)));
        } else {
            EditorUtils.CloseEditor.run((IEditorPart)this);
        }
        this.selectRootModelOfEditor();
    }

    private void selectRootModelOfEditor() {
        Display.getDefault().asyncExec(() -> {
            GraphicalViewer viewer = this.getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                Object selection = this.getSelection(viewer);
                EditorUtils.refreshPropertySheetWithSelection((IEditorPart)this, (GraphicalViewer)viewer, (Object)selection);
            }
        });
    }

    private Object getSelection(GraphicalViewer viewer) {
        Object selection = null;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof DiagramEditorWithFlyoutPalette) {
            selection = viewer.getEditPartRegistry().get(((DiagramEditorWithFlyoutPalette)activeEditor).getModel());
        }
        if (selection == null) {
            selection = viewer.getRootEditPart();
        }
        return selection;
    }

    public void updateEditorInput(FileEditorInput newInput) {
        this.setInput((IEditorInput)newInput);
        this.setTitleToolTip(newInput.getFile().getFullPath().toOSString());
    }
}

