/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.StructTreeNode;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.views.WatchValueTreeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class WatchesContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private WatchValueTreeNode root;
    private volatile boolean hasValueOnForte = false;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            int featureID = notification.getFeatureID(MonitoringElement.class);
            if (featureID == 4 && notification.getNotifier() instanceof MonitoringElement) {
                Display.getDefault().asyncExec(() -> {
                    if (!WatchesContentProvider.this.viewer.getControl().isDisposed()) {
                        WatchValueTreeNode node;
                        MonitoringElement element = (MonitoringElement)notification.getNotifier();
                        if (!WatchesContentProvider.this.hasValueOnForte) {
                            WatchesContentProvider.this.init();
                            WatchesContentProvider.this.hasValueOnForte = true;
                        }
                        if ((node = WatchesContentProvider.this.getNodeFromElement(element)) != null) {
                            this.updateNodeElement(node, element);
                        }
                    }
                });
            }
        }

        private void updateNodeElement(WatchValueTreeNode node, MonitoringElement element) {
            WatchValueTreeNode newNode = WatchValueTreeNode.createNode(element, WatchesContentProvider.this.root);
            WatchesContentProvider.this.root.getChildren().remove((Object)newNode);
            this.udpateNodeValue(node, newNode);
            WatchesContentProvider.this.getTreeViewer().refresh();
        }

        private void udpateNodeValue(WatchValueTreeNode node, WatchValueTreeNode newNode) {
            node.setValue(newNode.getValue());
            this.udpateChildren(node, newNode);
        }

        private void udpateChildren(WatchValueTreeNode node, WatchValueTreeNode newNode) {
            if (node.getChildren().size() != newNode.getChildren().size()) {
                return;
            }
            int i = 0;
            while (i < node.getChildren().size()) {
                WatchValueTreeNode oldNode = (WatchValueTreeNode)((Object)node.getChildren().get(i));
                WatchValueTreeNode newNodeChild = (WatchValueTreeNode)((Object)newNode.getChildren().get(i));
                oldNode.setValue(newNodeChild.getValue());
                this.udpateChildren(oldNode, newNodeChild);
                ++i;
            }
        }
    };

    public WatchesContentProvider() {
        this.init();
    }

    public void update() {
        this.init();
    }

    private void init() {
        Object[] expandedElements = null;
        if (this.root != null) {
            expandedElements = (Object[])this.getTreeViewer().getExpandedElements().clone();
        }
        this.root = new WatchValueTreeNode(null);
        Collection<MonitoringBaseElement> elementsToMonitor = MonitoringManager.getInstance().getAllElementsToMonitor();
        for (MonitoringBaseElement element : elementsToMonitor) {
            if (element == null) continue;
            this.hasValueOnForte = !((MonitoringElement)element).getCurrentValue().equals("N/A");
            WatchValueTreeNode node = this.root.addChild(element);
            if (expandedElements != null) {
                this.getTreeViewer().refresh((Object)node);
                this.updateExpandedState(Arrays.asList(expandedElements), node);
            }
            if (element.eAdapters().contains((Object)this.adapter)) continue;
            element.eAdapters().add((Object)this.adapter);
        }
        this.sortChildrenAsc();
    }

    public void sortChildrenAsc() {
        Collections.sort(this.root.getChildren(), (node1, node2) -> {
            String s1 = ((WatchValueTreeNode)((Object)node1)).getWatchedElementString();
            String s2 = ((WatchValueTreeNode)((Object)node2)).getWatchedElementString();
            return s1.compareToIgnoreCase(s2);
        });
    }

    private void updateExpandedState(List<Object> expanded, WatchValueTreeNode newNode) {
        for (Object e : expanded) {
            if (!WatchesContentProvider.hasBeenExpanded(newNode, e)) continue;
            this.getTreeViewer().setExpandedState((Object)newNode, true);
        }
        newNode.getChildren().forEach(c -> this.updateExpandedState(expanded, (WatchValueTreeNode)((Object)c)));
    }

    private static boolean hasBeenExpanded(WatchValueTreeNode newNode, Object e) {
        return e instanceof WatchValueTreeNode && ((WatchValueTreeNode)((Object)e)).getMonitoringBaseElement().equals(newNode.getMonitoringBaseElement()) && ((WatchValueTreeNode)((Object)e)).getWatchedElementString().equals(newNode.getWatchedElementString());
    }

    public WatchValueTreeNode getNodeFromElement(MonitoringElement monitoringElement) {
        return this.root.getChildren().stream().filter(node -> ((WatchValueTreeNode)((Object)node)).getMonitoringBaseElement().equals(monitoringElement)).findAny().orElse(null);
    }

    public Object[] getChildren(Object parentElement) {
        Assert.isTrue((boolean)(parentElement instanceof WatchValueTreeNode));
        return ((WatchValueTreeNode)((Object)parentElement)).getChildrenAsArray();
    }

    public Object getParent(Object element) {
        return ((WatchValueTreeNode)((Object)element)).getParent();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String) {
            return false;
        }
        Assert.isTrue((boolean)(element instanceof WatchValueTreeNode));
        return ((WatchValueTreeNode)((Object)element)).hasChildren();
    }

    public Object[] getElements(Object inputElement) {
        return this.root.getChildrenAsArray();
    }

    public void dispose() {
        this.removeAdapterFromChildrenList();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    private void removeAdapterFromChildrenList() {
        for (StructTreeNode node : this.root.getChildren()) {
            MonitoringBaseElement element = ((WatchValueTreeNode)node).getMonitoringBaseElement();
            if (!element.eAdapters().contains((Object)this.adapter)) continue;
            element.eAdapters().remove((Object)this.adapter);
        }
    }

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.viewer;
    }
}

