/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.validation.ValueValidator;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringEditPart;
import org.eclipse.fordiac.ide.monitoring.handlers.AbstractMonitoringHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class ForceHandler
extends AbstractMonitoringHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MonitoringManager manager;
        MonitoringBaseElement element;
        super.execute(event);
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        VarDeclaration variable = ForceHandler.getVariable(selection.getFirstElement());
        if (variable != null && (element = (manager = MonitoringManager.getInstance()).getMonitoringElement((IInterfaceElement)variable)) instanceof MonitoringElement) {
            MonitoringElement monitoringElement = (MonitoringElement)element;
            DataType type = monitoringElement.getPort().getInterfaceElement().getType();
            InputDialog input = new InputDialog(Display.getDefault().getActiveShell(), "Force Value", "Value", monitoringElement.isForce() ? monitoringElement.getForceValue() : "", newValue -> ForceHandler.validateForceInput(type, newValue));
            int ret = input.open();
            if (ret == 0) {
                manager.forceValue(monitoringElement, input.getValue());
            }
        }
        return null;
    }

    private static String validateForceInput(DataType type, String newValue) {
        String validationMsg;
        if (!newValue.isBlank() && (validationMsg = ValueValidator.validateValue((DataType)type, (String)newValue)) != null && !validationMsg.trim().isEmpty()) {
            return validationMsg;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean needToAdd = false;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            VarDeclaration variable;
            StructuredSelection sel = (StructuredSelection)selection;
            MonitoringManager manager = MonitoringManager.getInstance();
            if (1 == sel.size() && (variable = ForceHandler.getVariable(sel.getFirstElement())) != null && manager.containsPort((IInterfaceElement)variable)) {
                needToAdd = true;
            }
        }
        this.setBaseEnabled(needToAdd);
    }

    static VarDeclaration getVariable(Object object) {
        IInterfaceElement ie = null;
        if (object instanceof InterfaceEditPart) {
            ie = ((InterfaceEditPart)object).getModel();
        } else if (object instanceof MonitoringEditPart) {
            ie = ((MonitoringEditPart)((Object)object)).getModel().getPort().getInterfaceElement();
        }
        if (ie instanceof VarDeclaration) {
            return (VarDeclaration)ie;
        }
        return null;
    }
}

