/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class DataTypeDropdown
extends TextCellEditor {
    private ContentProposalAdapter adapter;
    private Text textControl;
    private DataTypeLibrary library;
    private SimpleContentProposalProvider provider;
    private List<DataType> types;
    private String[] elementaryTypes;
    private final TableViewer viewer;
    private boolean isElementary;
    private boolean isTraverseNextProcessActive;
    private boolean isTraversePreviousProcessActive;
    static final char[] ACTIVATION_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '.', '\b'};

    public DataTypeDropdown(DataTypeLibrary library, TableViewer viewer) {
        super((Composite)viewer.getTable());
        this.library = library;
        this.viewer = viewer;
        this.types = new ArrayList<DataType>();
        this.configureTextControl();
        this.createDialogButton();
        this.enableContentProposal();
        this.loadContent();
    }

    public DataType getType(String value) {
        return this.types.stream().filter(type -> value.equals(type.getName())).findAny().orElse(null);
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            this.textControl.setText("");
        } else {
            super.doSetValue(value);
        }
    }

    public void setDataTypeLibrary(DataTypeLibrary library) {
        this.library = library;
        this.loadContent();
    }

    private void loadContent() {
        this.types = this.getDataTypesSorted();
        this.provider.setProposals(this.getTypesAsStringArray());
    }

    protected List<DataType> getDataTypesSorted() {
        if (this.library != null) {
            return this.library.getDataTypesSorted().stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout contLayout = new GridLayout(2, false);
        contLayout.horizontalSpacing = 0;
        contLayout.marginTop = 0;
        contLayout.marginBottom = 0;
        contLayout.marginWidth = 0;
        contLayout.marginHeight = 0;
        contLayout.verticalSpacing = 0;
        contLayout.horizontalSpacing = 0;
        container.setLayout((Layout)contLayout);
        this.textControl = (Text)super.createControl(container);
        return container;
    }

    private void configureTextControl() {
        this.textControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textControl.addModifyListener(e -> {
            this.loadContent();
            if (this.textControl.getText().isEmpty()) {
                this.provider.setProposals(this.getElementaryTypes());
                this.isElementary = true;
            } else if (this.isElementary) {
                this.provider.setProposals(this.getTypesAsStringArray());
                this.isElementary = false;
            }
        });
        this.textControl.addListener(31, e -> {
            e.doit = false;
            if (e.detail == 16 && (e.stateMask & 0x40000) != 0) {
                int selIndex = this.viewer.getTable().getSelectionIndex() + 1;
                if (selIndex < this.viewer.getTable().getItemCount()) {
                    Object data = this.viewer.getTable().getItem(selIndex).getData();
                    this.viewer.editElement(data, 1);
                }
            } else if (e.detail == 8 && (e.stateMask & 0x40000) != 0) {
                int selIndex = this.viewer.getTable().getSelectionIndex() - 1;
                if (selIndex >= 0) {
                    Object data = this.viewer.getTable().getItem(selIndex).getData();
                    this.viewer.editElement(data, 1);
                }
            } else if (e.detail == 16) {
                if (this.adapter.isProposalPopupOpen()) {
                    DataTypeDropdown.triggerEnterKeyEvent();
                    this.isTraverseNextProcessActive = true;
                } else {
                    this.traverseToNextCell();
                }
            } else if (e.detail == 8) {
                if (this.adapter.isProposalPopupOpen()) {
                    DataTypeDropdown.triggerEnterKeyEvent();
                    this.isTraversePreviousProcessActive = true;
                } else {
                    this.traverseToPreviousCell();
                }
            }
        });
    }

    private static void triggerEnterKeyEvent() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Event event = new Event();
        event.keyCode = 13;
        event.display = display;
        event.type = 1;
        display.post(event);
    }

    private void traverseToPreviousCell() {
        int selIndex = this.viewer.getTable().getSelectionIndex();
        Object data = this.viewer.getTable().getItem(selIndex).getData();
        this.adapter.setEnabled(false);
        this.viewer.editElement(data, 0);
        this.adapter.setEnabled(true);
    }

    private void traverseToNextCell() {
        int selIndex = this.viewer.getTable().getSelectionIndex();
        Object data = this.viewer.getTable().getItem(selIndex).getData();
        this.adapter.setEnabled(false);
        this.viewer.editElement(data, 2);
        this.adapter.setEnabled(true);
    }

    private String[] getElementaryTypes() {
        if (this.elementaryTypes == null) {
            this.elementaryTypes = (String[])this.types.stream().filter(type -> !(type instanceof StructuredType)).map(INamedElement::getName).toArray(String[]::new);
        }
        return this.elementaryTypes;
    }

    private String[] getTypesAsStringArray() {
        return (String[])this.types.stream().map(INamedElement::getName).toArray(String[]::new);
    }

    private void createDialogButton() {
        Button menuButton = new Button((Composite)this.getControl(), 0x800000);
        menuButton.setText("...");
        menuButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDropdown.this.openDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void openDialog() {
        TypeNode node;
        this.loadContent();
        ITreeContentProvider treeProvider = DataTypeDropdown.createTreeContentProvider();
        LabelProvider labelProvider = DataTypeDropdown.createTreeLabelProvider();
        DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getControl().getShell(), (IBaseLabelProvider)labelProvider, treeProvider);
        dialog.setInput(this.types);
        dialog.setTitle(Messages.DataTypeDropdown_Type_Selection);
        dialog.setMessage(Messages.DataTypeDropdown_Select_Type);
        dialog.setDoubleClickSelects(false);
        dialog.setHelpAvailable(false);
        if (dialog.open() != 0) {
            this.deactivate();
            return;
        }
        Object result = dialog.getFirstResult();
        if (result instanceof TypeNode && !(node = (TypeNode)result).isDirectory()) {
            this.doSetValue(node.getName());
            this.fireApplyEditorValue();
        }
        this.deactivate();
    }

    private static LabelProvider createTreeLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TypeNode) {
                    return ((TypeNode)element).getName();
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                if (element instanceof TypeNode) {
                    TypeNode node = (TypeNode)element;
                    if (node.isDirectory()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
                    }
                    return FordiacImage.ICON_DATA_TYPE.getImage();
                }
                return super.getImage(element);
            }
        };
    }

    private static ITreeContentProvider createTreeContentProvider() {
        return new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof TypeNode) {
                    return !((TypeNode)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                TypeNode elementaries = new TypeNode(Messages.DataTypeDropdown_Elementary_Types);
                TypeNode structures = new TypeNode(Messages.DataTypeDropdown_STRUCT_Types);
                if (inputElement instanceof List) {
                    ((List)inputElement).forEach(type -> {
                        if (type instanceof StructuredType) {
                            StructuredType structuredType = (StructuredType)type;
                            if (structuredType.getPaletteEntry() != null) {
                                String parentPath = structuredType.getPaletteEntry().getFile().getParent().getProjectRelativePath().toOSString();
                                this.createSubdirectories(structures, structuredType, parentPath);
                            } else {
                                TypeNode runtimeNode = new TypeNode(structuredType.getName(), (DataType)structuredType);
                                runtimeNode.setParent(structures);
                                structures.addChild(runtimeNode);
                            }
                        } else if (type instanceof DataType) {
                            DataType simpleType = (DataType)type;
                            TypeNode newNode = new TypeNode(simpleType.getName(), simpleType);
                            elementaries.addChild(newNode);
                        }
                    });
                }
                if (elementaries.children.isEmpty()) {
                    return new TypeNode[]{structures};
                }
                return new TypeNode[]{elementaries, structures};
            }

            private void createSubdirectories(TypeNode node, StructuredType structuredType, String parentPath) {
                String[] paths = parentPath.split("\\\\");
                int i = 1;
                while (i < paths.length) {
                    TypeNode current = new TypeNode(paths[i]);
                    int index = node.getChildren().indexOf(current);
                    if (-1 != index) {
                        node = node.getChildren().get(index);
                    } else {
                        current.setParent(node);
                        node.addChild(current);
                        node = current;
                    }
                    ++i;
                }
                TypeNode actualType = new TypeNode(structuredType.getName(), (DataType)structuredType);
                actualType.setParent(node);
                node.addChild(actualType);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TypeNode) {
                    return ((TypeNode)parentElement).getChildren().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof TypeNode) {
                    return ((TypeNode)element).getParent();
                }
                return null;
            }
        };
    }

    private void enableContentProposal() {
        this.provider = new SimpleContentProposalProvider(this.getTypesAsStringArray());
        this.provider.setFiltering(true);
        this.adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.provider, null, ACTIVATION_CHARS);
        this.adapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
            }

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                DataTypeDropdown.this.loadContent();
            }
        });
        this.adapter.addContentProposalListener(proposal -> {
            this.fireApplyEditorValue();
            if (this.isTraverseNextProcessActive) {
                this.traverseToNextCell();
                this.isTraverseNextProcessActive = false;
            } else if (this.isTraversePreviousProcessActive) {
                this.traverseToPreviousCell();
                this.isTraversePreviousProcessActive = false;
            }
        });
        this.adapter.setProposalAcceptanceStyle(2);
    }

    protected void focusLost() {
        if (!this.insideAnyEditorArea()) {
            this.deactivate();
        }
    }

    private boolean insideAnyEditorArea() {
        Point cursorLocation = this.getControl().getDisplay().getCursorLocation();
        Point containerRelativeCursor = this.getControl().getParent().toControl(cursorLocation);
        return this.getControl().getBounds().contains(containerRelativeCursor);
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    private class DataTypeTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        public DataTypeTreeSelectionDialog(Shell parent, IBaseLabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.createContextMenu((Control)this.getTreeViewer().getTree());
            return control;
        }

        private void createContextMenu(final Control control) {
            Menu openEditorMenu = new Menu(control);
            final MenuItem openItem = new MenuItem(openEditorMenu, 0);
            openItem.addListener(13, e -> {
                StructuredType sel = this.getSelectedStructuredType(control);
                if (sel != null) {
                    this.handleShellCloseEvent();
                    this.setResult(null);
                    OpenStructMenu.openStructEditor(sel.getPaletteEntry().getFile());
                }
            });
            openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
            openEditorMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    StructuredType type = DataTypeTreeSelectionDialog.this.getSelectedStructuredType(control);
                    openItem.setEnabled(type != null && type != IecTypes.GenericTypes.ANY_STRUCT);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            control.setMenu(openEditorMenu);
        }

        private StructuredType getSelectedStructuredType(Control control) {
            DataType dtp;
            Object selected = ((TreeSelection)this.getTreeViewer().getSelection()).getFirstElement();
            if (selected instanceof TypeNode && (dtp = ((TypeNode)selected).getType()) instanceof StructuredType) {
                return (StructuredType)dtp;
            }
            return null;
        }
    }

    private static class TypeNode
    implements Comparable<TypeNode> {
        private final String name;
        private final List<TypeNode> children;
        private TypeNode parent;
        private DataType type;

        private TypeNode(String name) {
            this.name = name;
            this.children = new ArrayList<TypeNode>();
        }

        public boolean isDirectory() {
            return this.type == null;
        }

        private TypeNode(String name, DataType type) {
            this.name = name;
            this.type = type;
            this.children = new ArrayList<TypeNode>();
        }

        private String getName() {
            return this.name;
        }

        private List<TypeNode> getChildren() {
            return this.children;
        }

        private void addChild(TypeNode child) {
            int index = Collections.binarySearch(this.children, child);
            if (index < 0) {
                this.children.add(-index - 1, child);
            }
        }

        private TypeNode getParent() {
            return this.parent;
        }

        private void setParent(TypeNode parent) {
            this.parent = parent;
        }

        public DataType getType() {
            return this.type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeNode other = (TypeNode)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(TypeNode other) {
            return this.name.toLowerCase().compareTo(other.getName().toLowerCase());
        }
    }
}

