/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.validation;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterRoot;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.LocalVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PartialAccess;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PrimaryVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextPackage;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.TimeLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Variable;
import org.eclipse.fordiac.ide.model.structuredtext.validation.AbstractStructuredTextValidator;
import org.eclipse.fordiac.ide.model.structuredtext.validation.DatetimeLiteral;
import org.eclipse.xtext.validation.Check;

public class StructuredTextValidator
extends AbstractStructuredTextValidator {
    private boolean isPartialIndexInDataType(Variable variable) {
        boolean _xblockexpression = false;
        int varBitSize = this.BitSize(variable);
        int partSize = this.BitSize(variable.getPart());
        int index = variable.getPart().getIndex();
        int startIndex = index * partSize;
        int endIndex = startIndex + partSize;
        _xblockexpression = endIndex > varBitSize;
        return _xblockexpression;
    }

    @Check
    public void checkPartialAccess(PrimaryVariable v) {
        boolean _isPartialIndexInDataType;
        boolean _tripleNotEquals;
        PartialAccess _part = v.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals && (_isPartialIndexInDataType = this.isPartialIndexInDataType(v))) {
            this.error("Incorrect partial access: index not within limits.", (EStructuralFeature)StructuredTextPackage.Literals.PRIMARY_VARIABLE__VAR);
        }
    }

    @Check
    public void checkPartialAccess(AdapterVariable v) {
        boolean _isPartialIndexInDataType;
        boolean _tripleNotEquals;
        PartialAccess _part = v.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals && (_isPartialIndexInDataType = this.isPartialIndexInDataType(v))) {
            this.error("Incorrect partial access: index not within limits.", (EStructuralFeature)StructuredTextPackage.Literals.ADAPTER_VARIABLE__VAR);
        }
    }

    private int _BitSize(PartialAccess part) {
        int _xifexpression = 0;
        if (part != null) {
            int _xifexpression_1 = 0;
            boolean _isBitaccess = part.isBitaccess();
            if (_isBitaccess) {
                _xifexpression_1 = this.BitSize(IecTypes.ElementaryTypes.BOOL);
            } else {
                int _xifexpression_2 = 0;
                boolean _isByteaccess = part.isByteaccess();
                if (_isByteaccess) {
                    _xifexpression_2 = this.BitSize(IecTypes.ElementaryTypes.BYTE);
                } else {
                    int _xifexpression_3 = 0;
                    boolean _isWordaccess = part.isWordaccess();
                    if (_isWordaccess) {
                        _xifexpression_3 = this.BitSize(IecTypes.ElementaryTypes.WORD);
                    } else {
                        int _xifexpression_4 = 0;
                        boolean _isDwordaccess = part.isDwordaccess();
                        _xifexpression_4 = _isDwordaccess ? this.BitSize(IecTypes.ElementaryTypes.DWORD) : 0;
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = 0;
        }
        return _xifexpression;
    }

    private int _BitSize(PrimaryVariable variable) {
        return this.BitSize(variable.getVar().getType());
    }

    private int _BitSize(AdapterVariable variable) {
        return this.BitSize(variable.getVar().getType());
    }

    private int _BitSize(DataType type) {
        int _switchResult = 0;
        boolean _matched = false;
        if (Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.LWORD)) {
            _matched = true;
            _switchResult = 64;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.DWORD)) {
            _matched = true;
            _switchResult = 32;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.WORD)) {
            _matched = true;
            _switchResult = 16;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.BYTE)) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.BOOL)) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 0;
        }
        return _switchResult;
    }

    private int _BitSize(VarDeclaration v) {
        return this.BitSize(this.extractTypeInformation((EObject)v));
    }

    private int _BitSize(LocalVariable v) {
        return this.BitSize(this.extractTypeInformation((EObject)v));
    }

    private int _BitSize(String str) {
        boolean _equals_4;
        boolean _equals_3;
        boolean _equals_2;
        boolean _equals_1;
        int _switchResult = 0;
        boolean _matched = false;
        boolean _equals = str.equals("LWORD");
        if (_equals) {
            _matched = true;
            _switchResult = 64;
        }
        if (!_matched && (_equals_1 = str.equals("DWORD"))) {
            _matched = true;
            _switchResult = 32;
        }
        if (!_matched && (_equals_2 = str.equals("WORD"))) {
            _matched = true;
            _switchResult = 16;
        }
        if (!_matched && (_equals_3 = str.equals("BYTE"))) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched && (_equals_4 = str.equals("BOOL"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 0;
        }
        return _switchResult;
    }

    private String _extractTypeInformation(PartialAccess part, String DataType2) {
        String _xifexpression = null;
        if (part != null) {
            String _xifexpression_1 = null;
            boolean _isBitaccess = part.isBitaccess();
            if (_isBitaccess) {
                _xifexpression_1 = "BOOL";
            } else {
                String _xifexpression_2 = null;
                boolean _isByteaccess = part.isByteaccess();
                if (_isByteaccess) {
                    _xifexpression_2 = "BYTE";
                } else {
                    String _xifexpression_3 = null;
                    boolean _isWordaccess = part.isWordaccess();
                    if (_isWordaccess) {
                        _xifexpression_3 = "WORD";
                    } else {
                        String _xifexpression_4 = null;
                        boolean _isDwordaccess = part.isDwordaccess();
                        _xifexpression_4 = _isDwordaccess ? "DWORD" : "";
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = DataType2;
        }
        return _xifexpression;
    }

    private String _extractTypeInformation(PrimaryVariable variable, String DataType2) {
        String _xifexpression = null;
        _xifexpression = variable != null && variable.getPart() != null ? this.extractTypeInformation(variable.getPart()) : variable.getVar().getType().getName();
        return _xifexpression;
    }

    private String _extractTypeInformation(Variable variable, String DataType2) {
        String _xifexpression = null;
        _xifexpression = variable != null && variable.getPart() != null ? this.extractTypeInformation(variable.getPart()) : "";
        return _xifexpression;
    }

    protected String _extractTypeInformation(PrimaryVariable variable) {
        return this.extractTypeInformation(variable, this.extractTypeInformation((EObject)variable.getVar()));
    }

    protected String _extractTypeInformation(VarDeclaration variable) {
        return variable.getType().getName();
    }

    protected String _extractTypeInformation(AdapterVariable variable) {
        String _xblockexpression = null;
        AdapterVariable head = variable.getCurr();
        String _switchResult = null;
        boolean _matched = false;
        if (head instanceof AdapterRoot) {
            _matched = true;
            _switchResult = ((AdapterRoot)head).getAdapter().getType().getName();
        }
        if (!_matched && head instanceof AdapterVariable) {
            _matched = true;
            _switchResult = head.getVar().getType().getName();
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    @Check
    public void checkLocalVariable(LocalVariable v) {
        if (v.isLocated() && v.isInitalized()) {
            this.error("Located variables can not be initialized.", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__INITIAL_VALUE);
        } else if (v.isArray() && v.isInitalized()) {
            this.error("Local arrays can not be initialized.", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__INITIAL_VALUE);
        }
    }

    @Check
    public void checkArray(LocalVariable v) {
        boolean _isArray = v.isArray();
        if (_isArray) {
            int _arrayStop;
            int _arrayStart_1;
            boolean _greaterEqualsThan;
            boolean _notEquals;
            int _arrayStart = v.getArrayStart();
            boolean bl = _notEquals = _arrayStart != 0;
            if (_notEquals) {
                this.error("Only arrays with a start index of 0 are supported.", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__ARRAY);
            }
            boolean bl2 = _greaterEqualsThan = (_arrayStart_1 = v.getArrayStart()) >= (_arrayStop = v.getArrayStop());
            if (_greaterEqualsThan) {
                this.error("Only arrays with incrementing index are supported.", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__ARRAY);
            }
        }
    }

    private int extractArraySize(VarDeclaration v) {
        if (v instanceof LocalVariable) {
            int _arrayStop = ((LocalVariable)v).getArrayStop();
            int _arrayStart = ((LocalVariable)v).getArrayStart();
            int _minus = _arrayStop - _arrayStart;
            return _minus + 1;
        }
        return v.getArraySize();
    }

    @Check
    public void checkAtLocation(LocalVariable v) {
        if (v.isLocated() && v.getLocation() != null) {
            if ((this.BitSize(v.getLocation()) == 0 || this.BitSize(v) == 0) && v.isArray()) {
                this.error("Piecewise located variables are allowed only for variables of type ANY_BIT", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__LOCATED);
            }
            if (this.BitSize(v.getLocation()) > 0 && this.BitSize(v) > 0 && v.isArray() && this.extractArraySize((VarDeclaration)v) * this.BitSize(v) > this.BitSize(v.getLocation())) {
                this.error("Piecewise located variables cannot access more bits than are available in the destination", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__LOCATED);
            }
            if (this.BitSize(v) == 0 && this.BitSize(v.getLocation()) == 0 && !Objects.equal((Object)this.extractTypeInformation(v.getLocation(), this.extractTypeInformation(v.getLocation())), (Object)this.extractTypeInformation((EObject)v))) {
                this.error("General located variables must have matching types", (EStructuralFeature)StructuredTextPackage.Literals.LOCAL_VARIABLE__LOCATED);
            }
        }
    }

    @Check
    public void validateTimeLiteral(TimeLiteral expr) {
        boolean _not;
        String _literal = expr.getLiteral();
        DatetimeLiteral literal = new DatetimeLiteral(_literal);
        boolean _isValid = literal.isValid();
        boolean bl = _not = !_isValid;
        if (_not) {
            this.error("Invalid Literal", (EStructuralFeature)StructuredTextPackage.Literals.TIME_LITERAL__LITERAL);
        }
    }

    private int BitSize(Object v) {
        if (v instanceof LocalVariable) {
            return this._BitSize((LocalVariable)v);
        }
        if (v instanceof VarDeclaration) {
            return this._BitSize((VarDeclaration)v);
        }
        if (v instanceof DataType) {
            return this._BitSize((DataType)v);
        }
        if (v instanceof AdapterVariable) {
            return this._BitSize((AdapterVariable)v);
        }
        if (v instanceof PrimaryVariable) {
            return this._BitSize((PrimaryVariable)v);
        }
        if (v instanceof PartialAccess) {
            return this._BitSize((PartialAccess)v);
        }
        if (v instanceof String) {
            return this._BitSize((String)v);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(v).toString());
    }

    private String extractTypeInformation(EObject variable, String DataType2) {
        if (variable instanceof PrimaryVariable) {
            return this._extractTypeInformation((PrimaryVariable)variable, DataType2);
        }
        if (variable instanceof Variable) {
            return this._extractTypeInformation((Variable)variable, DataType2);
        }
        if (variable instanceof PartialAccess) {
            return this._extractTypeInformation((PartialAccess)variable, DataType2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable, DataType2).toString());
    }

    protected String extractTypeInformation(EObject variable) {
        if (variable instanceof VarDeclaration) {
            return this._extractTypeInformation((VarDeclaration)variable);
        }
        if (variable instanceof AdapterVariable) {
            return this._extractTypeInformation((AdapterVariable)variable);
        }
        if (variable instanceof PrimaryVariable) {
            return this._extractTypeInformation((PrimaryVariable)variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }
}

