/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;

public class UnmapCommand
extends Command {
    private final Mapping mapping;
    private final AutomationSystem system;
    private DeleteFBNetworkElementCommand deleteMappedFBCmd;

    public UnmapCommand(FBNetworkElement element) {
        super(FordiacMessages.Unmap);
        this.mapping = element.getMapping();
        this.system = this.mapping.getAutomationSystem();
    }

    public boolean canExecute() {
        return this.mapping != null && this.system != null;
    }

    public void execute() {
        this.deleteMappedFBCmd = new DeleteFBNetworkElementCommand(this.mapping.getTo());
        this.mapping.getFrom().setMapping(null);
        this.mapping.getTo().setMapping(null);
        this.system.getMapping().remove((Object)this.mapping);
        this.deleteMappedFBCmd.execute();
    }

    public void undo() {
        this.deleteMappedFBCmd.undo();
        this.mapping.getFrom().setMapping(this.mapping);
        this.mapping.getTo().setMapping(this.mapping);
        this.system.getMapping().add((Object)this.mapping);
    }

    public void redo() {
        this.mapping.getFrom().setMapping(null);
        this.mapping.getTo().setMapping(null);
        this.system.getMapping().remove((Object)this.mapping);
        this.deleteMappedFBCmd.redo();
    }

    public FBNetworkElement getMappedFBNetworkElement() {
        return this.deleteMappedFBCmd.getFBNetworkElement();
    }
}

