/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class MapToCommand
extends Command {
    private final FBNetworkElement srcElement;
    private final Resource resource;
    private UnmapCommand unmappFromExistingTarget;
    private FBNetworkElement targetElement;
    private final Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
    private final CompoundCommand createdConnections = new CompoundCommand();

    public MapToCommand(FBNetworkElement srcElement, Resource resource) {
        this.srcElement = srcElement;
        this.resource = resource;
    }

    public boolean canExecute() {
        if (this.srcElement == null) {
            return false;
        }
        if (this.srcElement.isMapped() && this.srcElement.getOpposite().getFbNetwork().equals(this.resource.getFBNetwork())) {
            ErrorMessenger.popUpErrorMessage((String)Messages.MapToCommand_STATUSMessage_AlreadyMapped);
            return false;
        }
        boolean supports = MapToCommand.deviceSupportsType();
        if (!supports) {
            ErrorMessenger.popUpErrorMessage((String)Messages.MapToCommand_STATUSMessage_TypeNotSupported);
        }
        return supports;
    }

    private static boolean deviceSupportsType() {
        return true;
    }

    public void execute() {
        if (this.srcElement.isMapped()) {
            this.unmappFromExistingTarget = new UnmapCommand(this.srcElement.getOpposite());
            this.unmappFromExistingTarget.execute();
        }
        this.createTargetElement();
        this.mapping.setFrom(this.srcElement);
        this.mapping.setTo(this.targetElement);
        this.srcElement.setMapping(this.mapping);
        this.targetElement.setMapping(this.mapping);
        this.getAutomationSystem().getMapping().add((Object)this.mapping);
        this.checkConnections();
        this.createdConnections.execute();
    }

    public void undo() {
        this.createdConnections.undo();
        this.srcElement.setMapping(null);
        this.targetElement.setMapping(null);
        this.getTargetFBNetwork().getNetworkElements().remove((Object)this.targetElement);
        this.getAutomationSystem().getMapping().remove((Object)this.mapping);
        if (this.unmappFromExistingTarget != null) {
            this.unmappFromExistingTarget.undo();
        }
    }

    public void redo() {
        if (this.unmappFromExistingTarget != null) {
            this.unmappFromExistingTarget.redo();
        }
        this.getTargetFBNetwork().getNetworkElements().add((Object)this.targetElement);
        this.srcElement.setMapping(this.mapping);
        this.targetElement.setMapping(this.mapping);
        this.getAutomationSystem().getMapping().add((Object)this.mapping);
        this.createdConnections.redo();
    }

    protected void createTargetElement() {
        if (this.srcElement instanceof StructManipulator) {
            this.targetElement = this.createTargetStructManipulator();
        } else if (this.srcElement instanceof FB) {
            this.targetElement = this.createTargetFB();
        } else if (this.srcElement instanceof SubApp) {
            this.targetElement = this.srcElement.getPaletteEntry() != null ? this.createTargetTypedSubApp() : this.createTargetUntypedSubApp();
        }
        this.targetElement.setName(this.srcElement.getName());
        this.transferFBParams();
    }

    private FBNetworkElement createTargetFB() {
        FBCreateCommand targetCreateFB = new FBCreateCommand((FBTypePaletteEntry)this.srcElement.getPaletteEntry(), this.getTargetFBNetwork(), this.srcElement.getPosition().getX(), this.srcElement.getPosition().getY());
        targetCreateFB.execute();
        return targetCreateFB.getFB();
    }

    private FBNetworkElement createTargetStructManipulator() {
        StructManipulator manipulator = (StructManipulator)this.createTargetFB();
        manipulator.setStructTypeElementsAtInterface(((StructManipulator)this.srcElement).getStructType());
        return manipulator;
    }

    private FBNetworkElement createTargetTypedSubApp() {
        if (this.srcElement instanceof SubApp) {
            FBNetworkHelper.loadSubappNetwork((FBNetworkElement)this.srcElement);
        }
        CreateSubAppInstanceCommand cmd = new CreateSubAppInstanceCommand((SubApplicationTypePaletteEntry)this.srcElement.getPaletteEntry(), this.getTargetFBNetwork(), this.srcElement.getPosition().getX(), this.srcElement.getPosition().getY());
        cmd.execute();
        return cmd.getSubApp();
    }

    private FBNetworkElement createTargetUntypedSubApp() {
        SubApp element = LibraryElementFactory.eINSTANCE.createSubApp();
        element.setPosition((Position)EcoreUtil.copy((EObject)this.srcElement.getPosition()));
        element.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        element.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.srcElement.getInterface()));
        for (IInterfaceElement ie : element.getInterface().getAllInterfaceElements()) {
            ie.getInputConnections().clear();
            ie.getOutputConnections().clear();
        }
        this.getTargetFBNetwork().getNetworkElements().add((Object)element);
        return element;
    }

    private void transferFBParams() {
        EList destInputs = this.targetElement.getInterface().getInputVars();
        EList srcInputs = this.srcElement.getInterface().getInputVars();
        int i = 0;
        while (i < destInputs.size()) {
            VarDeclaration srcVar = (VarDeclaration)srcInputs.get(i);
            VarDeclaration dstVar = (VarDeclaration)destInputs.get(i);
            if (srcVar.getValue() != null && !srcVar.getValue().getValue().isEmpty()) {
                if (dstVar.getValue() == null) {
                    dstVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
                }
                dstVar.getValue().setValue(srcVar.getValue().getValue());
            }
            ++i;
        }
    }

    private AutomationSystem getAutomationSystem() {
        return this.srcElement.getFbNetwork().getApplication().getAutomationSystem();
    }

    private void checkConnections() {
        for (IInterfaceElement interfaceElement : this.srcElement.getInterface().getAllInterfaceElements()) {
            if (interfaceElement instanceof ErrorMarkerInterface) continue;
            if (interfaceElement.isIsInput()) {
                this.checkInputConnections(interfaceElement);
                continue;
            }
            this.checkOutputConnections(interfaceElement);
        }
    }

    private void checkInputConnections(IInterfaceElement interfaceElement) {
        for (Connection connection : interfaceElement.getInputConnections()) {
            Resource res = connection.getSourceElement().getResource();
            if (!this.resource.equals(res) || connection.getSource() instanceof ErrorMarkerInterface) continue;
            this.addConnectionCreateCommand(connection.getSourceElement().getOpposite().getInterfaceElement(connection.getSource().getName()), this.targetElement.getInterfaceElement(interfaceElement.getName()));
        }
    }

    private void checkOutputConnections(IInterfaceElement interfaceElement) {
        for (Connection connection : interfaceElement.getOutputConnections()) {
            Resource res;
            if (MapToCommand.isSelfConnection(connection) || !this.resource.equals(res = connection.getDestinationElement().getResource()) || connection.getDestination() instanceof ErrorMarkerInterface) continue;
            IInterfaceElement destination = connection.getDestinationElement().getOpposite().getInterfaceElement(connection.getDestination().getName());
            this.addConnectionCreateCommand(this.targetElement.getInterfaceElement(interfaceElement.getName()), destination);
            if (!(destination instanceof AdapterDeclaration) && !(destination instanceof VarDeclaration)) continue;
            this.checkForDeleteConnections(destination);
        }
    }

    private static boolean isSelfConnection(Connection connection) {
        return connection.getSourceElement() == connection.getDestinationElement();
    }

    private void addConnectionCreateCommand(IInterfaceElement source, IInterfaceElement destination) {
        AbstractConnectionCreateCommand cmd = this.getConnectionCreatCMD(source);
        if (cmd != null) {
            cmd.setSource(source);
            cmd.setDestination(destination);
            this.createdConnections.add((Command)cmd);
        }
    }

    private void checkForDeleteConnections(IInterfaceElement destination) {
    }

    private AbstractConnectionCreateCommand getConnectionCreatCMD(IInterfaceElement interfaceElement) {
        if (interfaceElement instanceof Event) {
            return new EventConnectionCreateCommand(this.resource.getFBNetwork());
        }
        if (interfaceElement instanceof AdapterDeclaration) {
            return new AdapterConnectionCreateCommand(this.resource.getFBNetwork());
        }
        if (interfaceElement instanceof VarDeclaration) {
            return new DataConnectionCreateCommand(this.resource.getFBNetwork());
        }
        return null;
    }

    private FBNetwork getTargetFBNetwork() {
        return this.resource.getFBNetwork();
    }
}

