/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public final class ElementSelector {
    public static void selectViewObjects(Collection<? extends Object> viewObjects) {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        GraphicalViewer viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.flush();
            List<EditPart> editParts = ElementSelector.getSelectableEditParts(viewer, viewObjects);
            if (!editParts.isEmpty()) {
                viewer.setSelection((ISelection)new StructuredSelection(editParts));
                if (viewer instanceof AdvancedScrollingGraphicalViewer) {
                    ((AdvancedScrollingGraphicalViewer)viewer).revealEditPart(editParts.get(0));
                } else {
                    viewer.reveal(editParts.get(0));
                }
            }
        }
    }

    private static List<EditPart> getSelectableEditParts(GraphicalViewer viewer, Collection<?> viewObjects) {
        ArrayList<EditPart> selectableChildren = new ArrayList<EditPart>();
        List children = viewer.getContents().getChildren();
        block0: for (Object view : viewObjects) {
            for (Object child : children) {
                if (!(child instanceof EditPart) || !((EditPart)child).getModel().equals(view)) continue;
                selectableChildren.add((EditPart)child);
                continue block0;
            }
        }
        return selectableChildren;
    }

    private ElementSelector() {
        throw new UnsupportedOperationException("do not instantiate this class");
    }
}

