/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;

public class MarqueeDragTracker
extends AbstractTool
implements DragTracker {
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    private int marqueeBehavior = MarqueeSelectionTool.DEFAULT_MARQUEE_BEHAVIOR;
    private Figure marqueeRectangleFigure;
    private int mode;
    private Collection<EditPart> selectedEditParts;
    private Request targetRequest;

    public MarqueeDragTracker() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected void applyProperty(Object key, Object value) {
        if (MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    protected Collection<EditPart> calculateMarqueeSelectedEditParts() {
        HashSet<EditPart> marqueeSelectedEditParts = new HashSet<EditPart>();
        marqueeSelectedEditParts.addAll(this.calculatePrimaryMarqueeSelectedEditParts());
        marqueeSelectedEditParts.addAll(this.calculateSecondaryMarqueeSelectedEditParts(marqueeSelectedEditParts));
        return marqueeSelectedEditParts;
    }

    private Collection<EditPart> calculatePrimaryMarqueeSelectedEditParts() {
        HashSet editPartsToProcess = new HashSet();
        if (this.marqueeBehavior != MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED && this.marqueeBehavior != MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED) {
            editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)((GraphicalEditPart)this.getCurrentViewer().getRootEditPart())));
        }
        if (this.marqueeBehavior != MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED && this.marqueeBehavior != MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED) {
            editPartsToProcess.addAll(EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)((GraphicalEditPart)this.getCurrentViewer().getRootEditPart())));
        }
        ArrayList<EditPart> marqueeSelectedEditParts = new ArrayList<EditPart>();
        for (EditPart element : editPartsToProcess) {
            GraphicalEditPart editPart = (GraphicalEditPart)element;
            if (!this.isMarqueeSelectable(editPart) || !this.isPrimaryMarqueeSelectedEditPart(editPart)) continue;
            marqueeSelectedEditParts.add((EditPart)editPart);
        }
        return marqueeSelectedEditParts;
    }

    private Collection<EditPart> calculateSecondaryMarqueeSelectedEditParts(Collection<EditPart> directlyMarqueeSelectedEditParts) {
        HashSet editPartsToProcess = new HashSet();
        for (EditPart directlyMarqueeSelectedEditPart : directlyMarqueeSelectedEditParts) {
            GraphicalEditPart marqueeSelectedEditPart = (GraphicalEditPart)directlyMarqueeSelectedEditPart;
            editPartsToProcess.addAll(marqueeSelectedEditPart.getSourceConnections());
            editPartsToProcess.addAll(marqueeSelectedEditPart.getTargetConnections());
        }
        HashSet<EditPart> secondaryMarqueeSelectedEditParts = new HashSet<EditPart>();
        for (EditPart element : editPartsToProcess) {
            GraphicalEditPart editPart = (GraphicalEditPart)element;
            if (!this.isSecondaryMarqueeSelectedEditPart(directlyMarqueeSelectedEditParts, (EditPart)editPart)) continue;
            secondaryMarqueeSelectedEditParts.add((EditPart)editPart);
        }
        return secondaryMarqueeSelectedEditParts;
    }

    private static Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    protected String getCommandName() {
        return "selection";
    }

    protected Rectangle getCurrentMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected int getCurrentSelectionMode() {
        return this.mode;
    }

    protected String getDebugName() {
        return "Marquee Tool: " + this.marqueeBehavior;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = this.createMarqueeFeedbackFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected MarqueeRectangleFigure createMarqueeFeedbackFigure() {
        return new MarqueeRectangleFigure();
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = MarqueeDragTracker.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isCurrentViewerGraphical()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateMarqueeSelectedEditParts();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
        return editPart.getTargetEditPart(MARQUEE_REQUEST) == editPart && editPart.isSelectable() && FigureUtilities.isNotFullyClipped((IFigure)editPart.getFigure());
    }

    private boolean isPrimaryMarqueeSelectedEditPart(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle r = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)r);
        boolean included = false;
        Rectangle marqueeSelectionRectangle = this.getCurrentMarqueeSelectionRectangle();
        if (editPart instanceof ConnectionEditPart) {
            if ((this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED || this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED) && marqueeSelectionRectangle.intersects(r)) {
                Rectangle relMarqueeRect = Rectangle.SINGLETON;
                figure.translateToRelative((Translatable)relMarqueeRect.setBounds(marqueeSelectionRectangle));
                included = this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED ? ((Connection)figure).getPoints().intersects(relMarqueeRect) : relMarqueeRect.contains(((Connection)figure).getPoints().getBounds());
            }
        } else if (this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED || this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS) {
            included = marqueeSelectionRectangle.intersects(r);
        } else if (this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED || this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS) {
            included = marqueeSelectionRectangle.contains(r);
        }
        return included;
    }

    private boolean isSecondaryMarqueeSelectedEditPart(Collection<EditPart> directlyMarqueeSelectedEditParts, EditPart editPart) {
        boolean included = false;
        if (editPart instanceof ConnectionEditPart && (this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS || this.marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS)) {
            ConnectionEditPart connection = (ConnectionEditPart)editPart;
            GraphicalEditPart source = (GraphicalEditPart)connection.getSource();
            GraphicalEditPart target = (GraphicalEditPart)connection.getTarget();
            boolean sourceIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(source);
            boolean targetIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(target);
            if (this.mode == 0) {
                included = sourceIncludedInMarqueeSelection && targetIncludedInMarqueeSelection;
            } else if (this.mode == 2) {
                included = !(connection.getSelected() != 0 || !this.getCurrentViewer().getSelectedEditParts().contains(source) && !sourceIncludedInMarqueeSelection || !this.getCurrentViewer().getSelectedEditParts().contains(target) && !targetIncludedInMarqueeSelection);
            } else if (this.mode == 1) {
                included = connection.getSelected() == 0 ? (source.getSelected() == 0 && sourceIncludedInMarqueeSelection || source.getSelected() != 0 && !sourceIncludedInMarqueeSelection) && (target.getSelected() == 0 && targetIncludedInMarqueeSelection || target.getSelected() != 0 && !targetIncludedInMarqueeSelection) : source.getSelected() != 0 && sourceIncludedInMarqueeSelection || target.getSelected() != 0 && targetIncludedInMarqueeSelection;
            }
        }
        return included;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return this.isCurrentViewerGraphical();
    }

    private boolean isCurrentViewerGraphical() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        Collection<EditPart> marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
        LinkedHashSet<EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
        HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
        for (EditPart affectedEditPart : marqueeSelectedEditParts) {
            if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                editPartsToSelect.add(affectedEditPart);
                continue;
            }
            editPartsToDeselect.add(affectedEditPart);
        }
        if (this.getCurrentSelectionMode() != 0) {
            editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
            editPartsToSelect.removeAll(editPartsToDeselect);
        }
        this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED && type != MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED && type != MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED && type != MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS && type != MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED && type != MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(Cursors.CROSS);
        } else {
            this.setDefaultCursor(Cursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getCurrentMarqueeSelectionRectangle().getCopy();
        IFigure marqueeFeedbackFigure = this.getMarqueeFeedbackFigure();
        marqueeFeedbackFigure.translateToRelative((Translatable)rect);
        marqueeFeedbackFigure.setBounds(rect);
        marqueeFeedbackFigure.validate();
    }

    private void showTargetFeedback() {
        this.selectedEditParts.forEach(editPart -> editPart.showTargetFeedback(this.getTargetRequest()));
    }

    protected void handleFinished() {
    }

    private static class MarqueeRectangleFigure
    extends Figure {
        private MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
            graphics.setLineStyle(2);
            graphics.setLineWidth(3);
            graphics.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }
}

