/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.properties.AbstractEditInterfaceSection;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IContentProvider;

public abstract class AbstractEditInterfaceEventSection
extends AbstractEditInterfaceSection {
    @Override
    protected IContentProvider getOutputsContentProvider() {
        return new EventInterfaceContentProvider(false);
    }

    @Override
    protected IContentProvider getInputsContentProvider() {
        return new EventInterfaceContentProvider(true);
    }

    @Override
    protected String[] fillTypeCombo() {
        ArrayList<String> list = new ArrayList<String>();
        for (DataType dataType : EventTypeLibrary.getInstance().getEventTypes()) {
            list.add(dataType.getName());
        }
        return list.toArray(new String[0]);
    }

    protected DataType getLastUsedEventType(InterfaceList interfaceList, boolean isInput, IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            return interfaceElement.getType();
        }
        EList<Event> eventList = AbstractEditInterfaceEventSection.getEventList(interfaceList, isInput);
        if (!eventList.isEmpty()) {
            return ((Event)eventList.get(eventList.size() - 1)).getType();
        }
        return EventTypeLibrary.getInstance().getType(this.fillTypeCombo()[0]);
    }

    @Override
    protected int getInsertingIndex(IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            InterfaceList interfaceList = (InterfaceList)interfaceElement.eContainer();
            return this.getInsertingIndex(interfaceElement, AbstractEditInterfaceEventSection.getEventList(interfaceList, isInput));
        }
        return -1;
    }

    private static EList<Event> getEventList(InterfaceList interfaceList, boolean isInput) {
        return isInput ? interfaceList.getEventInputs() : interfaceList.getEventOutputs();
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof Event) {
            cmd.add((Command)this.newInsertCommand((IInterfaceElement)((Event)entry), this.isInputsViewer(), index));
        }
    }

    protected static class EventInterfaceContentProvider
    extends AbstractEditInterfaceSection.InterfaceContentProvider {
        public EventInterfaceContentProvider(boolean inputs) {
            super(inputs);
        }

        @Override
        protected Object[] getInputs(Object inputElement) {
            InterfaceList interfaceList = EventInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getEventInputs().toArray();
            }
            return new Object[0];
        }

        @Override
        protected Object[] getOutputs(Object inputElement) {
            InterfaceList interfaceList = EventInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getEventOutputs().toArray();
            }
            return new Object[0];
        }
    }
}

