/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.draw2d.SingleLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.AdvancedZoomManager;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.BackgroundFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.ModuloFreeformFigure;
import org.eclipse.fordiac.ide.gef.tools.CanvasHelper;
import org.eclipse.fordiac.ide.gef.tools.MarqueeDragTracker;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ZoomScalableFreeformRootEditPart
extends ScalableFreeformRootEditPart {
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    private static final Insets MARQUEE_DRAG_BORDER = new Insets(1, 1, 1, 1);
    public static final String TOP_LAYER = "TOPLAYER";

    public ZoomScalableFreeformRootEditPart(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        this.configureZoomManger();
        this.setupZoomActions(site, actionRegistry);
    }

    public DragTracker getDragTracker(Request req) {
        return new AdvancedMarqueeDragTracker();
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        ConnectionLayer connectionLayer = new ConnectionLayer();
        layeredPane.add((IFigure)connectionLayer, (Object)"Connection Layer");
        FreeformLayer topLayer = new FreeformLayer();
        topLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        layeredPane.add((IFigure)topLayer, (Object)TOP_LAYER);
        return layeredPane;
    }

    protected GridLayer createGridLayer() {
        return new MajorMinorGridLayer();
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected ScalableFreeformLayeredPane createScaledLayers() {
        ScalableFreeformLayeredPane pane = new ScalableFreeformLayeredPane(){

            protected void paintClientArea(Graphics graphics) {
                boolean optimizeClip;
                if (this.getChildren().isEmpty()) {
                    return;
                }
                boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
                if (!optimizeClip) {
                    graphics.clipRect(this.getBounds().getShrinked(this.getInsets()));
                }
                graphics.scale(this.getScale());
                graphics.pushState();
                this.paintChildren(graphics);
                graphics.popState();
            }
        };
        pane.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        pane.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        pane.add((IFigure)new FeedbackLayer(), (Object)"Scaled Feedback Layer");
        pane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        pane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        return pane;
    }

    private void configureZoomManger() {
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        this.getZoomManager().setZoomLevelContributions(zoomLevels);
        this.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 0.8, 0.85, 0.9, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0});
        this.getZoomManager().setZoomAnimationStyle(1);
    }

    private void setupZoomActions(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        ZoomInAction zoomIn = new ZoomInAction(this.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(this.getZoomManager());
        actionRegistry.registerAction((IAction)zoomIn);
        actionRegistry.registerAction((IAction)zoomOut);
        IHandlerService zoomInService = (IHandlerService)site.getService(IHandlerService.class);
        zoomInService.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        IHandlerService zoomOutService = (IHandlerService)site.getService(IHandlerService.class);
        zoomOutService.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
    }

    protected ZoomManager createZoomManager(ScalableFigure scalableFigure, Viewport viewport) {
        return new AdvancedZoomManager(scalableFigure, viewport);
    }

    protected IFigure createFigure() {
        FreeformViewport viewPort = (FreeformViewport)super.createFigure();
        FreeformLayeredPane drawingArea = (FreeformLayeredPane)viewPort.getContents();
        BackgroundFreeformFigure editorBackground = new BackgroundFreeformFigure(this);
        viewPort.setContents((IFigure)editorBackground);
        AbstractFreeformFigure drawingAreaContainer = this.createDrawingAreaContainer();
        ZoomScalableFreeformRootEditPart.configureDrawingContainer(drawingArea, drawingAreaContainer);
        editorBackground.setContents(drawingAreaContainer);
        return viewPort;
    }

    protected AbstractFreeformFigure createDrawingAreaContainer() {
        return new ModuloFreeformFigure(this);
    }

    private static void configureDrawingContainer(FreeformLayeredPane drawingArea, AbstractFreeformFigure drawingAreaContainer) {
        drawingAreaContainer.setOpaque(true);
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        drawingAreaContainer.setBackgroundColor(colorRegistry.get("org.eclipse.ui.editors.backgroundColor"));
        drawingAreaContainer.setBorder((Border)new SingleLineBorder());
        drawingAreaContainer.setContents((FreeformFigure)drawingArea);
    }

    public class AdvancedMarqueeDragTracker
    extends MarqueeDragTracker {
        @Override
        protected boolean handleButtonDown(int button) {
            if (3 == button) {
                ZoomScalableFreeformRootEditPart.this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            }
            return super.handleButtonDown(button);
        }

        public void mouseDown(MouseEvent me, EditPartViewer viewer) {
            if (viewer instanceof AdvancedScrollingGraphicalViewer) {
                CanvasHelper.bindToContentPane(me, (AdvancedScrollingGraphicalViewer)viewer, MARQUEE_DRAG_BORDER);
            }
            super.mouseDown(me, viewer);
        }

        public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
            if (this.isActive() && viewer instanceof AdvancedScrollingGraphicalViewer) {
                Point oldViewPort = ((AdvancedScrollingGraphicalViewer)viewer).getViewLocation();
                ((AdvancedScrollingGraphicalViewer)viewer).checkScrollPositionDuringDrag(me);
                Dimension delta = oldViewPort.getDifference(((AdvancedScrollingGraphicalViewer)viewer).getViewLocation());
                this.setStartLocation(this.getStartLocation().getTranslated(delta));
                CanvasHelper.bindToContentPane(me, (AdvancedScrollingGraphicalViewer)viewer, MARQUEE_DRAG_BORDER);
            }
            super.mouseDrag(me, viewer);
        }

        protected boolean handleDoubleClick(int button) {
            if (1 == button) {
                this.performOpen();
            }
            return true;
        }

        protected void performOpen() {
            EditPart editPart = this.getCurrentViewer().findObjectAt(this.getLocation());
            if (editPart != null) {
                SelectionRequest request = new SelectionRequest();
                request.setLocation(this.getLocation());
                request.setType((Object)"open");
                editPart.performRequest((Request)request);
            }
        }

        @Override
        protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
            return editPart.getTargetEditPart(MARQUEE_REQUEST) == editPart && editPart.isSelectable();
        }
    }

    private static class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }

    private static class MajorMinorGridLayer
    extends GridLayer {
        private static final double MIN_ABSOLUTE_INTERLEAVE = 5.0;
        private static final int MAJOR_INTERLEAVE = 10;
        private static final int MEDIUM_INTERLEAVE = 5;
        private static final float[] GRID_MINOR_DASHES_STYLE = new float[]{1.0f, 5.0f};
        private static final float[] GRID_MEDIUM_DASHES_STYLE = new float[]{2.0f, 4.0f};
        private static final float[] GRID_MAJOR_DASHES_STYLE = new float[]{4.0f, 2.0f};

        private MajorMinorGridLayer() {
        }

        protected void paintGrid(Graphics g) {
            int origLineStyle = g.getLineStyle();
            g.setLineStyle(6);
            Rectangle clip = g.getClip(Rectangle.SINGLETON);
            if (this.gridX > 0) {
                this.drawVerLines(g, clip);
            }
            if (this.gridY > 0) {
                this.drawHorLines(g, clip);
            }
            g.setLineStyle(origLineStyle);
        }

        private void drawVerLines(Graphics g, Rectangle clip) {
            int medInterleaveX = this.gridX * 5;
            int majorInterleaveX = this.gridX * 10;
            int realInterleaveX = MajorMinorGridLayer.determineInterleave(this.gridX, medInterleaveX, majorInterleaveX, g.getAbsoluteScale());
            if (realInterleaveX > 0) {
                int i = MajorMinorGridLayer.getLineStart(this.origin.x, clip.x, realInterleaveX);
                while (i < clip.x + clip.width) {
                    MajorMinorGridLayer.setLineStyle(g, i, this.origin.x, majorInterleaveX, medInterleaveX);
                    g.drawLine(i, clip.y, i, clip.y + clip.height);
                    i += realInterleaveX;
                }
            }
        }

        private void drawHorLines(Graphics g, Rectangle clip) {
            int medInterleaveY = this.gridY * 5;
            int majorInterleaveY = this.gridY * 10;
            int realInterleaveY = MajorMinorGridLayer.determineInterleave(this.gridY, medInterleaveY, majorInterleaveY, g.getAbsoluteScale());
            if (realInterleaveY > 0) {
                int i = MajorMinorGridLayer.getLineStart(this.origin.y, clip.y, realInterleaveY);
                while (i < clip.y + clip.height) {
                    MajorMinorGridLayer.setLineStyle(g, i, this.origin.y, majorInterleaveY, medInterleaveY);
                    g.drawLine(clip.x, i, clip.x + clip.width, i);
                    i += realInterleaveY;
                }
            }
        }

        private static int determineInterleave(int interleave, int medInterleave, int majorInterleave, double absoluteScale) {
            if ((double)interleave * absoluteScale > 5.0) {
                return interleave;
            }
            if ((double)medInterleave * absoluteScale > 5.0) {
                return medInterleave;
            }
            if ((double)majorInterleave * absoluteScale > 5.0) {
                return majorInterleave;
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        private static int getLineStart(int origin, int clip, int distance) {
            block2: {
                newOrigin = origin;
                if (origin < clip) ** GOTO lbl8
                while (newOrigin - distance >= clip) {
                    newOrigin -= distance;
                }
                break block2;
lbl-1000:
                // 1 sources

                {
                    newOrigin += distance;
lbl8:
                    // 2 sources

                    ** while (newOrigin < clip)
                }
            }
            return newOrigin;
        }

        private static void setLineStyle(Graphics g, int currLinePos, int origin, int majorInterleave, int mediumInterleave) {
            int delta = origin - currLinePos;
            if (delta % majorInterleave == 0) {
                g.setLineDash(GRID_MAJOR_DASHES_STYLE);
            } else if (delta % mediumInterleave == 0) {
                g.setLineDash(GRID_MEDIUM_DASHES_STYLE);
            } else {
                g.setLineDash(GRID_MINOR_DASHES_STYLE);
            }
        }
    }
}

