/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDiagramEditPart;
import org.eclipse.fordiac.ide.gef.editparts.IChildrenProvider;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class AbstractFBNetworkEditPart
extends AbstractDiagramEditPart {
    private List<IChildrenProvider> childProviders = null;

    protected EList<FBNetworkElement> getNetworkElements() {
        return this.getModel().getNetworkElements();
    }

    public FBNetwork getModel() {
        return (FBNetwork)super.getModel();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.childProviders != null) {
            this.childProviders.clear();
            this.childProviders = null;
        }
    }

    protected List<?> getModelChildren() {
        ArrayList<FBNetworkElement> children = new ArrayList<FBNetworkElement>((Collection<FBNetworkElement>)this.getNetworkElements());
        children.addAll(this.getFBValues());
        for (IChildrenProvider provider : this.getChildrenProviders()) {
            if (!provider.isEnabled()) continue;
            children.addAll(provider.getChildren(this.getModel()));
        }
        return children;
    }

    protected Collection<Value> getFBValues() {
        ArrayList<Value> valueElements = new ArrayList<Value>();
        for (FBNetworkElement element : this.getNetworkElements()) {
            for (VarDeclaration interfaceElement : element.getInterface().getInputVars()) {
                if (interfaceElement.getValue() == null) continue;
                valueElements.add(interfaceElement.getValue());
            }
        }
        return valueElements;
    }

    private List<IChildrenProvider> getChildrenProviders() {
        if (this.childProviders == null) {
            this.getExtensions();
        }
        return this.childProviders;
    }

    private void getExtensions() {
        IConfigurationElement[] elems;
        this.childProviders = new ArrayList<IChildrenProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.gef", "ChildrenProvider");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IChildrenProvider) {
                    IChildrenProvider childrenProvider = (IChildrenProvider)object;
                    this.childProviders.add(childrenProvider);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading ChildrenProvider Extensions in org.eclipse.fordiac.ide.gef", (Exception)((Object)corex));
            }
            ++n2;
        }
    }
}

