/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCombinedCellEditor<T>
extends TextCellEditor {
    private Composite container;
    private CCombo comboBox;
    private T element;

    protected AbstractCombinedCellEditor(T element) {
        this.element = element;
    }

    protected AbstractCombinedCellEditor(Composite parent) {
        super(parent, 0);
    }

    protected AbstractCombinedCellEditor(T element, Composite parent) {
        this(element, parent, 0);
    }

    protected AbstractCombinedCellEditor(T element, Composite parent, int style) {
        super(parent, style);
        this.element = element;
    }

    protected CCombo getCombobox() {
        return this.comboBox;
    }

    protected Control createControl(Composite parent) {
        this.container = AbstractCombinedCellEditor.createContainer(parent);
        this.createComboBox(this.container);
        this.createText(this.container);
        return this.container;
    }

    private void createComboBox(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.setEditable(false);
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                AbstractCombinedCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                AbstractCombinedCellEditor.this.checkTextEnabled();
                AbstractCombinedCellEditor.this.editText();
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (!AbstractCombinedCellEditor.this.insideAnyEditorArea(e)) {
                    AbstractCombinedCellEditor.this.focusLost();
                }
            }
        });
        this.comboBox.addListener(1, event -> {
            if (event.keyCode == 27) {
                this.fireCancelEditor();
            }
        });
    }

    protected abstract void checkTextEnabled();

    protected abstract void editText();

    private void createText(Composite parent) {
        CLabel label1 = new CLabel(parent, this.getStyle());
        label1.setText("[");
        this.text = new Text(parent, 4);
        CLabel label2 = new CLabel(parent, this.getStyle());
        label2.setText("]");
        parent.setBackground(label2.getBackground());
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!AbstractCombinedCellEditor.this.insideAnyEditorArea(e)) {
                    AbstractCombinedCellEditor.this.focusLost();
                }
            }
        });
        this.text.addListener(1, event -> {
            switch (event.keyCode) {
                case 13: {
                    this.focusLost();
                    break;
                }
                case 27: {
                    this.fireCancelEditor();
                    break;
                }
            }
        });
    }

    private boolean insideAnyEditorArea(FocusEvent e) {
        Point cursorLocation = e.display.getCursorLocation();
        Point containerRelativeCursor = this.container.getParent().toControl(cursorLocation);
        return this.container.getBounds().contains(containerRelativeCursor);
    }

    protected void populateComboBoxItems(List<String> eventNames) {
        if (this.comboBox != null && eventNames != null) {
            this.comboBox.removeAll();
            for (String item : eventNames) {
                this.comboBox.add(item);
            }
            this.setValueValid(true);
        }
    }

    protected abstract void initData();

    protected abstract int getIndexToSelect(List<String> var1);

    public CCombo getCCombo() {
        return this.comboBox;
    }

    public Text getText() {
        return this.text;
    }

    public T getElement() {
        return this.element;
    }

    public Object doGetValue() {
        return new String[]{String.valueOf(this.comboBox.getSelectionIndex()), this.text.getText()};
    }

    protected void doSetValue(Object value) {
        this.element = value;
        this.initData();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public void fireCancelEditor() {
        super.fireCancelEditor();
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        if (!((Text)event.getSource()).getText().isEmpty()) {
            super.handleDefaultSelection(event);
        }
    }

    private static Composite createContainer(Composite parent) {
        Composite newContainer = new Composite(parent, 0);
        newContainer.setBackground(parent.getBackground());
        newContainer.setForeground(parent.getForeground());
        GridLayout contLayout = new GridLayout(4, false);
        contLayout.horizontalSpacing = 0;
        contLayout.marginTop = 0;
        contLayout.marginBottom = 0;
        contLayout.marginWidth = 0;
        contLayout.marginHeight = 0;
        contLayout.verticalSpacing = 0;
        contLayout.horizontalSpacing = 0;
        newContainer.setLayout((Layout)contLayout);
        return newContainer;
    }

    protected void focusLost() {
        this.applyEditorValueAndDeactivate();
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.handleInvalidSelection();
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void handleInvalidSelection() {
        int selection = this.comboBox.getSelectionIndex();
        String[] items = this.comboBox.getItems();
        if (items.length > 0 && selection >= 0 && selection < items.length) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), items[selection]));
        } else {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
        }
    }
}

