/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.export.ExportTemplate;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class ForteLibraryElementTemplate
extends ExportTemplate {
    public static final CharSequence EXPORT_PREFIX = "st_";

    public ForteLibraryElementTemplate(String name, Path prefix) {
        super(name, prefix);
    }

    protected abstract LibraryElement getType();

    protected CharSequence getExportPrefix() {
        return EXPORT_PREFIX;
    }

    protected CharSequence generateHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** FORTE Library Element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** This file was generated using the 4DIAC FORTE Export Filter V1.0.x NG!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** Name: ");
        String _name = this.getType().getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Description: ");
        String _comment = this.getType().getComment();
        _builder.append(_comment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Version:");
        _builder.newLine();
        EList _versionInfo = this.getType().getVersionInfo();
        for (VersionInfo info : _versionInfo) {
            _builder.append("***     ");
            String _version = info.getVersion();
            _builder.append(_version);
            _builder.append(": ");
            String _date = info.getDate();
            _builder.append(_date);
            _builder.append("/");
            String _author = info.getAuthor();
            _builder.append(_author);
            _builder.append(" - ");
            String _organization = info.getOrganization();
            _builder.append(_organization);
            _builder.append(" - ");
            String _remarks = info.getRemarks();
            _builder.append(_remarks);
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("*************************************************************************/");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef _");
        String _upperCase = this.getType().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this.getType().getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateIncludeGuardEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#endif // _");
        String _upperCase = this.getType().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateTypeIncludes(Iterable<VarDeclaration> vars) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getTypeName();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(vars, (Functions.Function1)_function)));
        for (String include : _set) {
            _builder.append("#include \"forte_");
            String _lowerCase = include.toLowerCase();
            _builder.append(_lowerCase);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
            boolean _startsWith = include.startsWith("ANY");
            if (!_startsWith) continue;
            _builder.append("#error type contains variables of type ANY. Please check the usage of these variables as we can not gurantee correct usage on export!");
            _builder.newLine();
        }
        Functions.Function1 _function_1 = it -> it.isArray();
        boolean _exists = IterableExtensions.exists(vars, (Functions.Function1)_function_1);
        if (_exists) {
            _builder.append("#include \"forte_array.h\"");
            _builder.newLine();
        }
        _builder.append("#include \"forte_array_at.h\"");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateAccessors(List<VarDeclaration> vars, String function) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration v : vars) {
            _builder.append("CIEC_");
            String _typeName = v.getTypeName();
            _builder.append(_typeName);
            _builder.append(" ");
            boolean _isArray = v.isArray();
            if (_isArray) {
                _builder.append("*");
            } else {
                _builder.append("&");
            }
            CharSequence _exportPrefix = this.getExportPrefix();
            _builder.append((Object)_exportPrefix);
            String _name = v.getName();
            _builder.append(_name);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            boolean _isArray_1 = v.isArray();
            if (_isArray_1) {
                _builder.append("  ");
                _builder.append("return static_cast<CIEC_");
                String _typeName_1 = v.getTypeName();
                _builder.append(_typeName_1, "  ");
                _builder.append("*>((*static_cast<CIEC_ARRAY *>(");
                _builder.append(function, "  ");
                _builder.append("(");
                int _indexOf = vars.indexOf(v);
                _builder.append((Object)_indexOf, "  ");
                _builder.append(")))[0]); //the first element marks the start of the array");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("  ");
                _builder.append("return *static_cast<CIEC_");
                String _typeName_2 = v.getTypeName();
                _builder.append(_typeName_2, "  ");
                _builder.append("*>(");
                _builder.append(function, "  ");
                _builder.append("(");
                int _indexOf_1 = vars.indexOf(v);
                _builder.append((Object)_indexOf_1, "  ");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence getFORTEString(String s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("g_nStringId");
        _builder.append(s);
        return _builder;
    }

    protected String getFORTENameList(List<? extends INamedElement> elements) {
        Functions.Function1 _function = it -> this.getFORTEString(it.getName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected String getFORTETypeList(List<? extends VarDeclaration> elements) {
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            boolean _isArray = it.isArray();
            if (_isArray) {
                CharSequence _fORTEString = this.getFORTEString("ARRAY");
                _builder.append((Object)_fORTEString);
                _builder.append(", ");
                int _arraySize = it.getArraySize();
                _builder.append((Object)_arraySize);
                _builder.append(", ");
            }
            CharSequence _fORTEString_1 = this.getFORTEString(it.getType().getName());
            _builder.append((Object)_fORTEString_1);
            return _builder.toString();
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }
}

