/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.data;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class ResourceDeploymentData {
    private final Resource res;
    private final List<FBDeploymentData> fbs = new ArrayList<FBDeploymentData>();
    private final List<ConnectionDeploymentData> connections = new ArrayList<ConnectionDeploymentData>();
    private final List<ParameterData> params = new ArrayList<ParameterData>();

    public Resource getRes() {
        return this.res;
    }

    public List<FBDeploymentData> getFbs() {
        return this.fbs;
    }

    public List<ConnectionDeploymentData> getConnections() {
        return this.connections;
    }

    public List<ParameterData> getParams() {
        return this.params;
    }

    public ResourceDeploymentData(Resource res) {
        this.res = res;
        this.addFBNetworkElements(new ArrayDeque<SubApp>(), res.getFBNetwork(), "");
    }

    private void addFBNetworkElements(Deque<SubApp> subAppHierarchy, FBNetwork fbNetwork, String prefix) {
        for (FBNetworkElement fbnElement : fbNetwork.getNetworkElements()) {
            if (fbnElement instanceof FB) {
                this.fbs.add(new FBDeploymentData(prefix, fbnElement));
                continue;
            }
            if (!(fbnElement instanceof SubApp)) continue;
            this.addSubAppParams((SubApp)fbnElement, subAppHierarchy, prefix);
            FBNetwork subAppInternalNetwork = ResourceDeploymentData.getFBNetworkForSubApp((SubApp)fbnElement);
            if (subAppInternalNetwork == null) continue;
            subAppHierarchy.addLast((SubApp)fbnElement);
            this.addFBNetworkElements(subAppHierarchy, subAppInternalNetwork, String.valueOf(prefix) + fbnElement.getName() + ".");
            subAppHierarchy.removeLast();
        }
        for (Connection con : fbNetwork.getEventConnections()) {
            this.addConnection(subAppHierarchy, con, prefix);
        }
        for (Connection con : fbNetwork.getDataConnections()) {
            this.addConnection(subAppHierarchy, con, prefix);
        }
        for (Connection con : fbNetwork.getAdapterConnections()) {
            this.addConnection(subAppHierarchy, con, prefix);
        }
    }

    private void addSubAppParams(SubApp subApp, Deque<SubApp> subAppHierarchy, String prefix) {
        for (VarDeclaration dataInput : subApp.getInterface().getInputVars()) {
            String val = DeploymentHelper.getVariableValue(dataInput, this.res.getAutomationSystem());
            if (val == null) continue;
            for (ConDeploymentDest destData : this.getSubappInterfaceconnections(subAppHierarchy, prefix, (IInterfaceElement)dataInput)) {
                this.params.add(new ParameterData(val, destData.prefix, (VarDeclaration)destData.destination));
            }
        }
    }

    private static FBNetwork getFBNetworkForSubApp(SubApp subApp) {
        FBNetwork retVal = subApp.getSubAppNetwork();
        if (retVal == null) {
            if (subApp.isTyped()) {
                retVal = subApp.getType().getFBNetwork();
            } else if (subApp.getOpposite() != null) {
                retVal = ((SubApp)subApp.getOpposite()).getSubAppNetwork();
            }
        }
        return retVal;
    }

    private void addConnection(Deque<SubApp> subAppHierarchy, Connection con, String prefix) {
        if (con.getSourceElement() != null && !(con.getSourceElement() instanceof SubApp) && !con.isResTypeConnection()) {
            for (ConDeploymentDest destData : this.getConnectionEndPoint(subAppHierarchy, prefix, con.getDestination())) {
                this.connections.add(new ConnectionDeploymentData(prefix, con.getSource(), destData.prefix, destData.destination));
            }
        }
    }

    private List<ConDeploymentDest> getConnectionEndPoint(Deque<SubApp> subAppHierarchy, String prefix, IInterfaceElement destination) {
        ArrayList<ConDeploymentDest> retVal = new ArrayList<ConDeploymentDest>();
        if (destination.getFBNetworkElement() != null && !(destination.getFBNetworkElement() instanceof SubApp)) {
            retVal.add(new ConDeploymentDest(prefix, destination));
        } else {
            retVal.addAll(this.getSubappInterfaceconnections(subAppHierarchy, prefix, destination));
        }
        return retVal;
    }

    private List<ConDeploymentDest> getSubappInterfaceconnections(Deque<SubApp> subAppHierarchy, String prefix, IInterfaceElement destination) {
        ArrayList<ConDeploymentDest> retVal = new ArrayList<ConDeploymentDest>();
        if (destination.isIsInput()) {
            String newPrefix = String.valueOf(prefix) + destination.getFBNetworkElement().getName() + ".";
            subAppHierarchy.addLast((SubApp)destination.getFBNetworkElement());
            IInterfaceElement internalElement = ResourceDeploymentData.getSubAppInteralElement(destination);
            if (internalElement != null) {
                for (Connection con : internalElement.getOutputConnections()) {
                    retVal.addAll(this.getConnectionEndPoint(subAppHierarchy, newPrefix, con.getDestination()));
                }
            }
            subAppHierarchy.removeLast();
        } else {
            String newPrefix = ResourceDeploymentData.removeLastEntry(prefix);
            SubApp currentSubApp = subAppHierarchy.removeLast();
            IInterfaceElement internalElement = currentSubApp.getInterfaceElement(destination.getName());
            for (Connection con : internalElement.getOutputConnections()) {
                retVal.addAll(this.getConnectionEndPoint(subAppHierarchy, newPrefix, con.getDestination()));
            }
            subAppHierarchy.addLast(currentSubApp);
        }
        return retVal;
    }

    private static IInterfaceElement getSubAppInteralElement(IInterfaceElement destination) {
        SubApp subApp = (SubApp)destination.getFBNetworkElement();
        if (subApp.getSubAppNetwork() != null) {
            return destination;
        }
        InterfaceList interfaceList = null;
        if (subApp.isTyped()) {
            interfaceList = subApp.getType().getInterfaceList();
        } else if (subApp.getOpposite() != null) {
            interfaceList = ((SubApp)subApp.getOpposite()).getInterface();
        }
        if (interfaceList != null) {
            return interfaceList.getInterfaceElement(destination.getName());
        }
        return null;
    }

    private static String removeLastEntry(String prefix) {
        int index = prefix.lastIndexOf(46, prefix.length() - 2);
        if (-1 != index) {
            return prefix.substring(0, index + 1);
        }
        return "";
    }

    private static class ConDeploymentDest {
        private final String prefix;
        private final IInterfaceElement destination;

        public ConDeploymentDest(String prefix, IInterfaceElement destination) {
            this.prefix = prefix;
            this.destination = destination;
        }
    }

    public static class ParameterData {
        private final String value;
        private final VarDeclaration variable;
        private final String prefix;

        public String getValue() {
            return this.value;
        }

        public VarDeclaration getVar() {
            return this.variable;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ParameterData(String value, String prefix, VarDeclaration variable) {
            this.value = value;
            this.variable = variable;
            this.prefix = prefix;
        }
    }
}

