/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class Deploy
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection<EObject> selected = Deploy.getDeployableObjects(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (!selected.isEmpty()) {
            DeploymentCoordinator.INSTANCE.performDeployment((Object[])selected.toArray(new EObject[selected.size()]));
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        boolean needToAdd = false;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof ISelection) {
            needToAdd = !Deploy.getDeployableObjects((ISelection)selection).isEmpty();
        }
        this.setBaseEnabled(needToAdd);
    }

    private static Collection<EObject> getDeployableObjects(ISelection selection) {
        HashSet<EObject> retVal = new HashSet<EObject>();
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                if (selectedObject instanceof EObject) {
                    Deploy.addEObject((EObject)selectedObject, retVal);
                } else if (selectedObject instanceof EditPart && ((EditPart)selectedObject).getModel() instanceof EObject) {
                    Deploy.addEObject((EObject)((EditPart)selectedObject).getModel(), retVal);
                } else if (SystemManager.isSystemFile((Object)selectedObject)) {
                    Deploy.addEObject((EObject)SystemManager.INSTANCE.getSystem((IFile)selectedObject), retVal);
                }
                ++n2;
            }
        }
        return retVal;
    }

    private static void addEObject(EObject object, Set<EObject> retVal) {
        if (object instanceof AutomationSystem) {
            for (Device dev : ((AutomationSystem)object).getSystemConfiguration().getDevices()) {
                Deploy.addDeviceContent(dev, retVal);
            }
        } else if (object instanceof SystemConfiguration) {
            for (Device dev : ((SystemConfiguration)object).getDevices()) {
                Deploy.addDeviceContent(dev, retVal);
            }
        } else if (object instanceof Device) {
            Deploy.addDeviceContent((Device)object, retVal);
        } else if (object instanceof Resource) {
            retVal.add(object);
        }
    }

    private static void addDeviceContent(Device dev, Set<EObject> retVal) {
        retVal.add((EObject)dev);
        for (Resource res : dev.getResource()) {
            retVal.add((EObject)res);
        }
    }
}

