/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.tools;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.tools.ScrollingConnectionEndpointTracker;
import org.eclipse.fordiac.ide.model.commands.change.AbstractReconnectConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;

public class FBNScrollingConnectionEndpointTracker
extends ScrollingConnectionEndpointTracker {
    private ConnectionRoutingData originalRoutingData;

    public FBNScrollingConnectionEndpointTracker(ConnectionEditPart cep) {
        super(cep);
    }

    protected boolean handleDragStarted() {
        Connection conn = this.get4diacConnection();
        if (conn != null) {
            this.originalRoutingData = (ConnectionRoutingData)EcoreUtil.copy((EObject)conn.getRoutingData());
        }
        return super.handleDragStarted();
    }

    protected void executeCurrentCommand() {
        if (this.shouldRestoreRoutingData()) {
            this.get4diacConnection().setRoutingData(this.originalRoutingData);
        }
        super.executeCurrentCommand();
    }

    protected Insets getCanvasBorder() {
        Connection conn = this.get4diacConnection();
        if (conn != null) {
            conn.getRoutingData().setNeedsValidation(true);
            if (conn.getRoutingData().is3SegementData() && "Reconnection source".equals(this.getCommandName())) {
                Insets adjustedBorder = new Insets(super.getCanvasBorder());
                adjustedBorder.right += conn.getRoutingData().getDx1();
                return adjustedBorder;
            }
            if (conn.getRoutingData().is5SegementData()) {
                return this.get5SegmentCanvasBorder(conn.getRoutingData());
            }
        }
        return super.getCanvasBorder();
    }

    private Insets get5SegmentCanvasBorder(ConnectionRoutingData routingData) {
        Insets adjustedBorder = new Insets(super.getCanvasBorder());
        if ("Reconnection source".equals(this.getCommandName())) {
            adjustedBorder.right += routingData.getDx1();
            if (routingData.getDy() < 0) {
                adjustedBorder.top -= routingData.getDy();
            }
        }
        if ("Reconnection target".equals(this.getCommandName())) {
            adjustedBorder.left += routingData.getDx2();
        }
        return adjustedBorder;
    }

    private boolean shouldRestoreRoutingData() {
        Connection con = this.get4diacConnection();
        if (con != null) {
            Command curCommand = this.getCurrentCommand();
            if (curCommand != null && curCommand.canExecute()) {
                if (curCommand instanceof AbstractReconnectConnectionCommand) {
                    AbstractReconnectConnectionCommand cmd = (AbstractReconnectConnectionCommand)curCommand;
                    return con.getSource().equals(cmd.getNewSource()) && con.getDestination().equals(cmd.getNewDestination());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected Connection get4diacConnection() {
        if (this.getConnectionEditPart().getModel() instanceof Connection) {
            return (Connection)this.getConnectionEditPart().getModel();
        }
        return null;
    }
}

