/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CreateConnectionSection
extends AbstractSection {
    private Text commentText;
    private Text sourceText;
    private Text targetText;

    private List<IInterfaceElement> getSelectionList() {
        return this.type instanceof List ? (List)this.type : Collections.emptyList();
    }

    protected List<IInterfaceElement> getInputType(Object input) {
        ArrayList<IInterfaceElement> editParts = new ArrayList<IInterfaceElement>();
        if (input instanceof IStructuredSelection && ((IStructuredSelection)input).getFirstElement() instanceof EditPart && ((EditPart)((IStructuredSelection)input).getFirstElement()).getModel() instanceof IInterfaceElement) {
            List selectionList = ((IStructuredSelection)input).toList();
            IInterfaceElement first = (IInterfaceElement)((EditPart)selectionList.get(0)).getModel();
            IInterfaceElement second = (IInterfaceElement)((EditPart)selectionList.get(1)).getModel();
            editParts.add(second);
            editParts.add(first);
        }
        return editParts;
    }

    protected EObject getType() {
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, org.eclipse.fordiac.ide.gef.Messages.ConnectionSection_Source);
        this.sourceText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, org.eclipse.fordiac.ide.gef.Messages.ConnectionSection_Target);
        this.targetText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, org.eclipse.fordiac.ide.gef.Messages.ConnectionSection_Comment);
        this.commentText = this.createGroupText(composite, true);
        Button createConnectionButton = this.getWidgetFactory().createButton(parent, Messages.CreateConnectionSection_CreateConnection, 8);
        createConnectionButton.setLayoutData((Object)new GridData(0, 4, false, true));
        createConnectionButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        createConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object cmd = null;
                IInterfaceElement source = CreateConnectionSection.this.getSelectionList().get(0);
                IInterfaceElement dest = CreateConnectionSection.this.getSelectionList().get(1);
                FBNetwork nw = CreateConnectionSection.getFBNetwork(source, dest);
                cmd = source instanceof Event ? new EventConnectionCreateCommand(nw) : (source instanceof AdapterDeclaration ? new AdapterConnectionCreateCommand(nw) : new DataConnectionCreateCommand(nw));
                cmd.setSource(source);
                cmd.setDestination(dest);
                CreateConnectionSection.this.executeCommand((Command)cmd);
            }
        });
    }

    private static FBNetwork getFBNetwork(IInterfaceElement source, IInterfaceElement dest) {
        if (source.eContainer().eContainer() instanceof CompositeFBType) {
            return ((CompositeFBType)source.eContainer().eContainer()).getFBNetwork();
        }
        if (source.getFBNetworkElement().getFbNetwork() != dest.getFBNetworkElement().getFbNetwork() && source.getFBNetworkElement() instanceof SubApp) {
            if (((SubApp)source.getFBNetworkElement()).getSubAppNetwork() == dest.getFBNetworkElement().getFbNetwork()) {
                return dest.getFBNetworkElement().getFbNetwork();
            }
            return source.getFBNetworkElement().getFbNetwork();
        }
        return source.getFBNetworkElement().getFbNetwork();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.commandStack = this.getCommandStack(part, selection);
        if (this.commandStack == null) {
            this.commentText.setEnabled(false);
            this.sourceText.setEnabled(false);
            this.targetText.setEnabled(false);
        }
        this.setType(selection);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.sourceText.setText(this.getInterfaceName(true));
            this.targetText.setText(this.getInterfaceName(false));
        }
        this.commandStack = commandStackBuffer;
    }

    private IInterfaceElement getInterfaceElement(boolean source) {
        if (source) {
            return (IInterfaceElement)((List)this.type).get(0);
        }
        return (IInterfaceElement)((List)this.type).get(1);
    }

    private String getInterfaceName(boolean source) {
        IInterfaceElement element = this.getInterfaceElement(source);
        return String.valueOf(CreateConnectionSection.getFBName((INamedElement)element)) + "." + ((INamedElement)element).getName();
    }

    private static String getFBName(INamedElement element) {
        return ((INamedElement)element.eContainer().eContainer()).getName();
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

