/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateFBTypeHandler
extends AbstractHandler {
    private final List<FBNetworkElement> selectedNetworkElements = new ArrayList<FBNetworkElement>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand cmd = new CompoundCommand();
        CommandStack stack = (CommandStack)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(CommandStack.class);
        for (FBNetworkElement element : this.selectedNetworkElements) {
            Command updateFBTypeCmd = UpdateFBTypeHandler.getUpdateCommand(element);
            if (!updateFBTypeCmd.canExecute()) continue;
            cmd.add(updateFBTypeCmd);
        }
        if (stack != null) {
            stack.execute((Command)cmd);
        }
        return Status.OK_STATUS;
    }

    public static Command getUpdateCommand(FBNetworkElement element) {
        if (element instanceof StructManipulator) {
            StructManipulator mux = (StructManipulator)element;
            DataTypeLibrary lib = mux.getType().getTypeLibrary().getDataTypeLibrary();
            StructuredType updated = (StructuredType)lib.getType(mux.getStructType().getName());
            return new ChangeStructCommand(mux, updated);
        }
        return new UpdateFBTypeCommand(element, null);
    }

    public void setEnabled(Object evaluationContext) {
        this.updateSelection(evaluationContext);
        this.setBaseEnabled(!this.selectedNetworkElements.isEmpty());
    }

    protected void updateSelection(Object evaluationContext) {
        this.selectedNetworkElements.clear();
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof EditPart) {
                    element = ((EditPart)element).getModel();
                }
                if (!(element instanceof FBNetworkElement) || ((FBNetworkElement)element).getType() == null) continue;
                this.selectedNetworkElements.add((FBNetworkElement)element);
            }
        }
    }
}

