/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.commands.NewSubAppCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewSubApplication
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        GraphicalViewer viewer = HandlerHelper.getViewer((IEditorPart)activeEditor);
        CommandStack cmdstack = (CommandStack)activeEditor.getAdapter(CommandStack.class);
        FBNetwork network = NewSubApplication.getFBNetwork(selection, event);
        Point pos = NewSubApplication.getInsertPos((EditPartViewer)viewer, selection);
        NewSubAppCommand cmd = new NewSubAppCommand(network, selection.toList(), pos.x, pos.y);
        cmdstack.execute((Command)cmd);
        HandlerHelper.selectElement((Object)cmd.getElement(), (GraphicalViewer)viewer);
        return Status.OK_STATUS;
    }

    private static FBNetwork getFBNetwork(StructuredSelection selection, ExecutionEvent event) {
        if (NewSubApplication.createNewEmptySubapp(selection)) {
            return (FBNetwork)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(FBNetwork.class);
        }
        for (Object o : selection) {
            Object model;
            if (!(o instanceof EditPart) || !((model = ((EditPart)o).getModel()) instanceof FBNetworkElement)) continue;
            return ((FBNetworkElement)model).getFbNetwork();
        }
        return null;
    }

    public static Point getInsertPos(EditPartViewer viewer, StructuredSelection selection) {
        if (NewSubApplication.createNewEmptySubapp(selection)) {
            return ((FBNetworkContextMenuProvider)viewer.getContextMenu()).getTranslatedAndZoomedPoint();
        }
        org.eclipse.swt.graphics.Point swtPos1 = FBNetworkHelper.getTopLeftCornerOfFBNetwork((List)selection.toList());
        return new Point(swtPos1.x, swtPos1.y);
    }

    private static boolean createNewEmptySubapp(StructuredSelection selection) {
        return selection.size() == 1 && !(((EditPart)selection.getFirstElement()).getModel() instanceof FBNetworkElement);
    }
}

